/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zza;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import java.util.ArrayList;
import java.util.List;

public final class ApplicationMetadata
implements SafeParcelable {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zza();
    private final int mVersionCode;
    String zzSX;
    String mName;
    List<WebImage> zzvL;
    List<String> zzSY;
    String zzSZ;
    Uri zzTa;

    ApplicationMetadata(int versionCode, String applicationId, String name, List<WebImage> images, List<String> namespaces, String senderAppIdentifier, Uri senderAppLaunchUrl) {
        this.mVersionCode = versionCode;
        this.zzSX = applicationId;
        this.mName = name;
        this.zzvL = images;
        this.zzSY = namespaces;
        this.zzSZ = senderAppIdentifier;
        this.zzTa = senderAppLaunchUrl;
    }

    private ApplicationMetadata() {
        this.mVersionCode = 1;
        this.zzvL = new ArrayList<WebImage>();
        this.zzSY = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getApplicationId() {
        return this.zzSX;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String namespace) {
        return this.zzSY != null && this.zzSY.contains(namespace);
    }

    public boolean areNamespacesSupported(List<String> namespaces) {
        return this.zzSY != null && this.zzSY.containsAll(namespaces);
    }

    public String getSenderAppIdentifier() {
        return this.zzSZ;
    }

    public Uri zzlM() {
        return this.zzTa;
    }

    public List<WebImage> getImages() {
        return this.zzvL;
    }

    public String toString() {
        return "applicationId: " + this.zzSX + ", name: " + this.mName + ", images.count: " + (this.zzvL == null ? 0 : this.zzvL.size()) + ", namespaces.count: " + (this.zzSY == null ? 0 : this.zzSY.size()) + ", senderAppIdentifier: " + this.zzSZ + ", senderAppLaunchUrl: " + this.zzTa;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mVersionCode, this.zzSX, this.mName, this.zzvL, this.zzSY, this.zzSZ, this.zzTa});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)obj;
        return zzf.zza(this.zzSX, applicationMetadata.zzSX) && zzf.zza(this.zzvL, applicationMetadata.zzvL) && zzf.zza(this.mName, applicationMetadata.mName) && zzf.zza(this.zzSY, applicationMetadata.zzSY) && zzf.zza(this.zzSZ, applicationMetadata.zzSZ) && zzf.zza(this.zzTa, applicationMetadata.zzTa);
    }
}

