/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.hardware.display;

import android.content.Context;
import android.os.Build;
import android.support.v4.hardware.display.DisplayManagerJellybeanMr1;
import android.view.Display;
import android.view.WindowManager;
import java.util.WeakHashMap;

public abstract class DisplayManagerCompat {
    private static final WeakHashMap<Context, DisplayManagerCompat> sInstances = new WeakHashMap();
    public static final String DISPLAY_CATEGORY_PRESENTATION = "android.hardware.display.category.PRESENTATION";

    DisplayManagerCompat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DisplayManagerCompat getInstance(Context context) {
        WeakHashMap<Context, DisplayManagerCompat> weakHashMap = sInstances;
        synchronized (weakHashMap) {
            DisplayManagerCompat instance = sInstances.get(context);
            if (instance == null) {
                int version = Build.VERSION.SDK_INT;
                instance = version >= 17 ? new JellybeanMr1Impl(context) : new LegacyImpl(context);
                sInstances.put(context, instance);
            }
            return instance;
        }
    }

    public abstract Display getDisplay(int var1);

    public abstract Display[] getDisplays();

    public abstract Display[] getDisplays(String var1);

    private static class JellybeanMr1Impl
    extends DisplayManagerCompat {
        private final Object mDisplayManagerObj;

        public JellybeanMr1Impl(Context context) {
            this.mDisplayManagerObj = DisplayManagerJellybeanMr1.getDisplayManager((Context)context);
        }

        @Override
        public Display getDisplay(int displayId) {
            return DisplayManagerJellybeanMr1.getDisplay((Object)this.mDisplayManagerObj, (int)displayId);
        }

        @Override
        public Display[] getDisplays() {
            return DisplayManagerJellybeanMr1.getDisplays((Object)this.mDisplayManagerObj);
        }

        @Override
        public Display[] getDisplays(String category) {
            return DisplayManagerJellybeanMr1.getDisplays((Object)this.mDisplayManagerObj, (String)category);
        }
    }

    private static class LegacyImpl
    extends DisplayManagerCompat {
        private final WindowManager mWindowManager;

        public LegacyImpl(Context context) {
            this.mWindowManager = (WindowManager)context.getSystemService("window");
        }

        @Override
        public Display getDisplay(int displayId) {
            Display display = this.mWindowManager.getDefaultDisplay();
            if (display.getDisplayId() == displayId) {
                return display;
            }
            return null;
        }

        @Override
        public Display[] getDisplays() {
            return new Display[]{this.mWindowManager.getDefaultDisplay()};
        }

        @Override
        public Display[] getDisplays(String category) {
            return category == null ? this.getDisplays() : new Display[]{};
        }
    }
}

