/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.zza;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzei;
import com.google.android.gms.internal.zzej;
import com.google.android.gms.internal.zzek;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzgk;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

@zzgk
public final class zzen
extends zzei.zza {
    private final MediationAdapter zzyW;
    private zzeo zzyX;

    public zzen(MediationAdapter mediationAdapter) {
        this.zzyW = mediationAdapter;
    }

    @Override
    public zzd getView() throws RemoteException {
        if (!(this.zzyW instanceof MediationBannerAdapter)) {
            zzb.zzaE("MediationAdapter is not a MediationBannerAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        try {
            MediationBannerAdapter mediationBannerAdapter = (MediationBannerAdapter)this.zzyW;
            return zze.zzx((Object)mediationBannerAdapter.getBannerView());
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not get banner view from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(zzd zzd2, AdSizeParcel adSizeParcel, AdRequestParcel adRequestParcel, String string2, zzej zzej2) throws RemoteException {
        this.zza(zzd2, adSizeParcel, adRequestParcel, string2, null, zzej2);
    }

    @Override
    public void zza(zzd zzd2, AdSizeParcel adSizeParcel, AdRequestParcel adRequestParcel, String string2, String string3, zzej zzej2) throws RemoteException {
        if (!(this.zzyW instanceof MediationBannerAdapter)) {
            zzb.zzaE("MediationAdapter is not a MediationBannerAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzaC("Requesting banner ad from adapter.");
        try {
            MediationBannerAdapter mediationBannerAdapter = (MediationBannerAdapter)this.zzyW;
            HashSet<String> hashSet = adRequestParcel.zzss != null ? new HashSet<String>(adRequestParcel.zzss) : null;
            zzem zzem2 = new zzem(adRequestParcel.zzsq == -1L ? null : new Date(adRequestParcel.zzsq), adRequestParcel.zzsr, hashSet, adRequestParcel.zzsy, adRequestParcel.zzst, adRequestParcel.zzsu);
            Bundle bundle = adRequestParcel.zzsA != null ? adRequestParcel.zzsA.getBundle(mediationBannerAdapter.getClass().getName()) : null;
            mediationBannerAdapter.requestBannerAd((Context)zze.zzp((zzd)zzd2), new zzeo(zzej2), this.zza(string2, adRequestParcel.zzsu, string3), com.google.android.gms.ads.zza.zza(adSizeParcel.width, adSizeParcel.height, adSizeParcel.zzsG), zzem2, bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not request banner ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(zzd zzd2, AdRequestParcel adRequestParcel, String string2, zzej zzej2) throws RemoteException {
        this.zza(zzd2, adRequestParcel, string2, null, zzej2);
    }

    @Override
    public void zza(zzd zzd2, AdRequestParcel adRequestParcel, String string2, String string3, zzej zzej2) throws RemoteException {
        if (!(this.zzyW instanceof MediationInterstitialAdapter)) {
            zzb.zzaE("MediationAdapter is not a MediationInterstitialAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzaC("Requesting interstitial ad from adapter.");
        try {
            MediationInterstitialAdapter mediationInterstitialAdapter = (MediationInterstitialAdapter)this.zzyW;
            HashSet<String> hashSet = adRequestParcel.zzss != null ? new HashSet<String>(adRequestParcel.zzss) : null;
            zzem zzem2 = new zzem(adRequestParcel.zzsq == -1L ? null : new Date(adRequestParcel.zzsq), adRequestParcel.zzsr, hashSet, adRequestParcel.zzsy, adRequestParcel.zzst, adRequestParcel.zzsu);
            Bundle bundle = adRequestParcel.zzsA != null ? adRequestParcel.zzsA.getBundle(mediationInterstitialAdapter.getClass().getName()) : null;
            mediationInterstitialAdapter.requestInterstitialAd((Context)zze.zzp((zzd)zzd2), new zzeo(zzej2), this.zza(string2, adRequestParcel.zzsu, string3), zzem2, bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not request interstitial ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(zzd zzd2, AdRequestParcel adRequestParcel, String string2, String string3, zzej zzej2, NativeAdOptionsParcel nativeAdOptionsParcel, List<String> list) throws RemoteException {
        if (!(this.zzyW instanceof zza)) {
            zzb.zzaE("MediationAdapter is not a MediationNativeAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        try {
            zza zza2 = (zza)this.zzyW;
            HashSet<String> hashSet = adRequestParcel.zzss != null ? new HashSet<String>(adRequestParcel.zzss) : null;
            zzer zzer2 = new zzer(adRequestParcel.zzsq == -1L ? null : new Date(adRequestParcel.zzsq), adRequestParcel.zzsr, hashSet, adRequestParcel.zzsy, adRequestParcel.zzst, adRequestParcel.zzsu, nativeAdOptionsParcel, list);
            Bundle bundle = adRequestParcel.zzsA != null ? adRequestParcel.zzsA.getBundle(zza2.getClass().getName()) : null;
            this.zzyX = new zzeo(zzej2);
            zza2.requestNativeAd((Context)zze.zzp((zzd)zzd2), this.zzyX, this.zza(string2, adRequestParcel.zzsu, string3), zzer2, bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not request interstitial ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public zzek zzdS() {
        NativeAdMapper nativeAdMapper = this.zzyX.zzdU();
        if (nativeAdMapper instanceof NativeAppInstallAdMapper) {
            return new zzep((NativeAppInstallAdMapper)nativeAdMapper);
        }
        return null;
    }

    @Override
    public zzel zzdT() {
        NativeAdMapper nativeAdMapper = this.zzyX.zzdU();
        if (nativeAdMapper instanceof NativeContentAdMapper) {
            return new zzeq((NativeContentAdMapper)nativeAdMapper);
        }
        return null;
    }

    @Override
    public void zza(zzd zzd2, AdRequestParcel adRequestParcel, String string2, com.google.android.gms.ads.internal.reward.mediation.client.zza zza2, String string3) throws RemoteException {
        if (!(this.zzyW instanceof MediationRewardedVideoAdAdapter)) {
            zzb.zzaE("MediationAdapter is not a MediationRewardedVideoAdAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzaC("Initialize rewarded video adapter.");
        try {
            MediationRewardedVideoAdAdapter mediationRewardedVideoAdAdapter = (MediationRewardedVideoAdAdapter)this.zzyW;
            HashSet<String> hashSet = adRequestParcel.zzss != null ? new HashSet<String>(adRequestParcel.zzss) : null;
            zzem zzem2 = new zzem(adRequestParcel.zzsq == -1L ? null : new Date(adRequestParcel.zzsq), adRequestParcel.zzsr, hashSet, adRequestParcel.zzsy, adRequestParcel.zzst, adRequestParcel.zzsu);
            Bundle bundle = adRequestParcel.zzsA != null ? adRequestParcel.zzsA.getBundle(mediationRewardedVideoAdAdapter.getClass().getName()) : null;
            mediationRewardedVideoAdAdapter.initialize((Context)zze.zzp((zzd)zzd2), zzem2, string2, new com.google.android.gms.ads.internal.reward.mediation.client.zzb(zza2), this.zza(string3, adRequestParcel.zzsu, null), bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not initialize rewarded video adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(AdRequestParcel adRequestParcel, String string2) throws RemoteException {
        if (!(this.zzyW instanceof MediationRewardedVideoAdAdapter)) {
            zzb.zzaE("MediationAdapter is not a MediationRewardedVideoAdAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzaC("Requesting rewarded video ad from adapter.");
        try {
            MediationRewardedVideoAdAdapter mediationRewardedVideoAdAdapter = (MediationRewardedVideoAdAdapter)this.zzyW;
            HashSet<String> hashSet = adRequestParcel.zzss != null ? new HashSet<String>(adRequestParcel.zzss) : null;
            zzem zzem2 = new zzem(adRequestParcel.zzsq == -1L ? null : new Date(adRequestParcel.zzsq), adRequestParcel.zzsr, hashSet, adRequestParcel.zzsy, adRequestParcel.zzst, adRequestParcel.zzsu);
            Bundle bundle = adRequestParcel.zzsA != null ? adRequestParcel.zzsA.getBundle(mediationRewardedVideoAdAdapter.getClass().getName()) : null;
            mediationRewardedVideoAdAdapter.loadAd(zzem2, this.zza(string2, adRequestParcel.zzsu, null), bundle);
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not load rewarded video ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void showVideo() throws RemoteException {
        if (!(this.zzyW instanceof MediationRewardedVideoAdAdapter)) {
            zzb.zzaE("MediationAdapter is not a MediationRewardedVideoAdAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzaC("Show rewarded video ad from adapter.");
        try {
            MediationRewardedVideoAdAdapter mediationRewardedVideoAdAdapter = (MediationRewardedVideoAdAdapter)this.zzyW;
            mediationRewardedVideoAdAdapter.showVideo();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not show rewarded video ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public boolean isInitialized() throws RemoteException {
        if (!(this.zzyW instanceof MediationRewardedVideoAdAdapter)) {
            zzb.zzaE("MediationAdapter is not a MediationRewardedVideoAdAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzaC("Check if adapter is initialized.");
        try {
            MediationRewardedVideoAdAdapter mediationRewardedVideoAdAdapter = (MediationRewardedVideoAdAdapter)this.zzyW;
            return mediationRewardedVideoAdAdapter.isInitialized();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not check if adapter is initialized.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void showInterstitial() throws RemoteException {
        if (!(this.zzyW instanceof MediationInterstitialAdapter)) {
            zzb.zzaE("MediationAdapter is not a MediationInterstitialAdapter: " + this.zzyW.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzb.zzaC("Showing interstitial from adapter.");
        try {
            MediationInterstitialAdapter mediationInterstitialAdapter = (MediationInterstitialAdapter)this.zzyW;
            mediationInterstitialAdapter.showInterstitial();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not show interstitial from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void destroy() throws RemoteException {
        try {
            this.zzyW.onDestroy();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not destroy adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void pause() throws RemoteException {
        try {
            this.zzyW.onPause();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not pause adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void resume() throws RemoteException {
        try {
            this.zzyW.onResume();
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not resume adapter.", throwable);
            throw new RemoteException();
        }
    }

    private Bundle zza(String string2, int n, String string3) throws RemoteException {
        zzb.zzaE("Server parameters: " + string2);
        try {
            Bundle bundle = new Bundle();
            if (string2 != null) {
                JSONObject jSONObject = new JSONObject(string2);
                bundle = new Bundle();
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    bundle.putString(string4, jSONObject.getString(string4));
                }
            }
            if (this.zzyW instanceof AdMobAdapter) {
                bundle.putString("adJson", string3);
                bundle.putInt("tagForChildDirectedTreatment", n);
            }
            return bundle;
        }
        catch (Throwable throwable) {
            zzb.zzd("Could not get Server Parameters Bundle.", throwable);
            throw new RemoteException();
        }
    }
}

