/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziq;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@zzgk
public final class zzdn
implements zzdg {
    private final zzdi zzxm;
    private final zze zzxj;
    private final zzew zzxk;

    public zzdn(zzdi zzdi2, zze zze2, zzew zzew2) {
        this.zzxm = zzdi2;
        this.zzxj = zze2;
        this.zzxk = zzew2;
    }

    @Override
    public void zza(zzip zzip2, Map<String, String> map) {
        String string2 = map.get("a");
        if (string2 == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Action missing from an open GMSG.");
            return;
        }
        if (this.zzxj != null && !this.zzxj.zzbe()) {
            this.zzxj.zzp(map.get("u"));
            return;
        }
        zziq zziq2 = zzip2.zzgS();
        if ("expand".equalsIgnoreCase(string2)) {
            if (zzip2.zzgW()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("Cannot expand WebView that is already expanded.");
                return;
            }
            this.zzm(false);
            zziq2.zza(zzdn.zzc(map), zzdn.zzd(map));
        } else if ("webapp".equalsIgnoreCase(string2)) {
            String string3 = map.get("u");
            this.zzm(false);
            if (string3 != null) {
                zziq2.zza(zzdn.zzc(map), zzdn.zzd(map), string3);
            } else {
                zziq2.zza(zzdn.zzc(map), zzdn.zzd(map), map.get("html"), map.get("baseurl"));
            }
        } else if ("in_app_purchase".equalsIgnoreCase(string2)) {
            String string4 = map.get("product_id");
            String string5 = map.get("report_urls");
            if (this.zzxm == null) {
                return;
            }
            if (string5 != null && !string5.isEmpty()) {
                String[] stringArray = string5.split(" ");
                this.zzxm.zza(string4, new ArrayList<String>(Arrays.asList(stringArray)));
            } else {
                this.zzxm.zza(string4, new ArrayList<String>());
            }
        } else if ("app".equalsIgnoreCase(string2) && "true".equalsIgnoreCase(map.get("play_store"))) {
            zzdn.zzb(zzip2, map);
        } else if ("app".equalsIgnoreCase(string2) && "true".equalsIgnoreCase(map.get("system_browser"))) {
            zzdn.zza(zzip2.getContext(), map);
        } else {
            this.zzm(true);
            zzan zzan2 = zzip2.zzgU();
            String string6 = map.get("u");
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (zzan2 != null && zzan2.zzb(Uri.parse((String)string6))) {
                    string6 = zzp.zzbx().zzd(zzip2.getContext(), string6, zzip2.zzha());
                }
                string6 = zzp.zzbx().zza(zzip2, string6);
            }
            zziq2.zza(new AdLauncherIntentInfoParcel(map.get("i"), string6, map.get("m"), map.get("p"), map.get("c"), map.get("f"), map.get("e")));
        }
    }

    private static void zzb(zzip zzip2, Map<String, String> map) {
        String string2 = map.get("u");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Destination url cannot be empty.");
            return;
        }
        zza zza2 = new zza(zzip2, string2);
        zza2.zzgn();
    }

    private static void zza(Context context, Map<String, String> map) {
        String string2 = map.get("u");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Destination url cannot be empty.");
            return;
        }
        zzb zzb2 = new zzb();
        Intent intent = zzb2.zzb(context, map);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE(activityNotFoundException.getMessage());
        }
    }

    private static boolean zzc(Map<String, String> map) {
        return "1".equals(map.get("custom_close"));
    }

    private static int zzd(Map<String, String> map) {
        String string2 = map.get("o");
        if (string2 != null) {
            if ("p".equalsIgnoreCase(string2)) {
                return zzp.zzbz().zzgw();
            }
            if ("l".equalsIgnoreCase(string2)) {
                return zzp.zzbz().zzgv();
            }
            if ("c".equalsIgnoreCase(string2)) {
                return zzp.zzbz().zzgx();
            }
        }
        return -1;
    }

    private void zzm(boolean bl) {
        if (this.zzxk != null) {
            this.zzxk.zzn(bl);
        }
    }

    public static class zzb {
        public Intent zzd(Uri uri) {
            if (uri == null) {
                return null;
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setData(uri);
            intent.setAction("android.intent.action.VIEW");
            return intent;
        }

        public ResolveInfo zza(Context context, Intent intent) {
            return this.zza(context, intent, new ArrayList<ResolveInfo>());
        }

        public ResolveInfo zza(Context context, Intent intent, ArrayList<ResolveInfo> arrayList) {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return null;
            }
            List list = packageManager.queryIntentActivities(intent, 65536);
            ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
            ResolveInfo resolveInfo2 = null;
            if (list != null && resolveInfo != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ResolveInfo resolveInfo3 = (ResolveInfo)list.get(i);
                    if (resolveInfo == null || !resolveInfo.activityInfo.name.equals(resolveInfo3.activityInfo.name)) continue;
                    resolveInfo2 = resolveInfo;
                    break;
                }
            }
            arrayList.addAll(list);
            return resolveInfo2;
        }

        public Intent zza(Intent intent, ResolveInfo resolveInfo) {
            Intent intent2 = new Intent(intent);
            intent2.setClassName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
            return intent2;
        }

        public Intent zzb(Context context, Map<String, String> map) {
            Object object;
            ResolveInfo resolveInfo3;
            Object object2;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            String string2 = map.get("u");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            Uri uri = Uri.parse((String)string2);
            boolean bl = Boolean.parseBoolean(map.get("use_first_package"));
            boolean bl2 = Boolean.parseBoolean(map.get("use_running_process"));
            Uri uri2 = null;
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("https").build();
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("http").build();
            }
            ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
            Intent intent = this.zzd(uri);
            Intent intent2 = this.zzd(uri2);
            ResolveInfo resolveInfo2 = this.zza(context, intent, arrayList);
            if (resolveInfo2 != null) {
                return this.zza(intent, resolveInfo2);
            }
            if (intent2 != null && (object2 = this.zza(context, intent2)) != null && (resolveInfo3 = this.zza(context, (Intent)(object = this.zza(intent, (ResolveInfo)object2)))) != null) {
                return object;
            }
            if (arrayList.size() == 0) {
                return intent;
            }
            if (bl2 && activityManager != null && (object2 = activityManager.getRunningAppProcesses()) != null) {
                for (ResolveInfo resolveInfo3 : arrayList) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                        if (!runningAppProcessInfo.processName.equals(resolveInfo3.activityInfo.packageName)) continue;
                        return this.zza(intent, resolveInfo3);
                    }
                }
            }
            if (bl) {
                return this.zza(intent, arrayList.get(0));
            }
            return intent;
        }
    }

    public static class zza
    extends zzhq {
        private final String zzxn = "play.google.com";
        private final String zzxo = "market";
        private final int zzxp = 10;
        private final String zzF;
        private final zzip zzoL;

        public zza(zzip zzip2, String string2) {
            this.zzoL = zzip2;
            this.zzF = string2;
        }

        public Intent zzY(String string2) {
            Uri uri = Uri.parse((String)string2);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setData(uri);
            return intent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzdG() {
            Object object;
            String string2 = this.zzF;
            int n = 0;
            while (n < 10) {
                ++n;
                try {
                    object = new URL(string2);
                    if ("play.google.com".equalsIgnoreCase(((URL)object).getHost()) || "market".equalsIgnoreCase(((URL)object).getProtocol())) break;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
                    try {
                        zzp.zzbx().zza(this.zzoL.getContext(), this.zzoL.zzgV().zzIz, false, httpURLConnection);
                        int n2 = httpURLConnection.getResponseCode();
                        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                        String string3 = "";
                        if (n2 >= 300 && n2 <= 399) {
                            List<String> list = null;
                            if (map.containsKey("Location")) {
                                list = map.get("Location");
                            } else if (map.containsKey("location")) {
                                list = map.get("location");
                            }
                            if (list != null && list.size() > 0) {
                                string3 = list.get(0);
                            }
                        }
                        if (TextUtils.isEmpty((CharSequence)string3)) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Arrived at landing page, this ideally should not happen. Will open it in browser.");
                            break;
                        }
                        string2 = string3;
                    }
                    finally {
                        httpURLConnection.disconnect();
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzd("Error while parsing ping URL: " + string2, indexOutOfBoundsException);
                    break;
                }
                catch (IOException iOException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzd("Error while pinging URL: " + string2, iOException);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzd("Error while pinging URL: " + string2, runtimeException);
                    break;
                }
            }
            object = this.zzY(string2);
            this.zzoL.getContext().startActivity((Intent)object);
        }

        @Override
        public void onStop() {
        }
    }
}

