/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzm;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzeb;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzfm;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzhu;
import java.util.ArrayList;
import java.util.UUID;

@zzgk
public abstract class zzb
extends zza
implements zzg,
zzj,
zzdi,
zzeb {
    protected final zzeh zzow;
    private final Messenger mMessenger;
    protected transient boolean zzox;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string, zzeh zzeh2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzq(context, adSizeParcel, string, versionInfoParcel), zzeh2, null, zzd2);
    }

    zzb(zzq zzq2, zzeh zzeh2, zzo zzo2, zzd zzd2) {
        super(zzq2, zzo2, zzd2);
        this.zzow = zzeh2;
        this.mMessenger = new Messenger((Handler)new zzfj(this.zzos.context));
        this.zzox = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzcd zzcd2) {
        if (!this.zzaU()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzp.zzbA().zzF(this.zzos.context));
        this.zzor.cancel();
        this.zzos.zzqz = 0;
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle);
        zzcd2.zzd("seq_num", zza2.zzDB);
        if (zza2.zzDQ != null) {
            zzcd2.zzd("request_id", zza2.zzDQ);
        }
        if (zza2.zzDz != null) {
            zzcd2.zzd("app_version", String.valueOf(zza2.zzDz.versionCode));
        }
        this.zzos.zzqd = zzp.zzbt().zza(this.zzos.context, zza2, this.zzos.zzqa, this);
        return true;
    }

    @Override
    public void zzb(zzhj zzhj2) {
        super.zzb(zzhj2);
        if (zzhj2.errorCode == 3 && zzhj2.zzGG != null && zzhj2.zzGG.zzyy != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Pinging no fill URLs.");
            zzp.zzbJ().zza(this.zzos.context, this.zzos.zzqb.zzIz, zzhj2, this.zzos.zzpZ, false, zzhj2.zzGG.zzyy);
        }
    }

    @Override
    protected boolean zza(zzhj zzhj2, zzhj zzhj3) {
        if (zzhj2 != null && zzhj2.zzyT != null) {
            zzhj2.zzyT.zza((zzeb)null);
        }
        if (zzhj3.zzyT != null) {
            zzhj3.zzyT.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzhj3.zzGG != null) {
            n = zzhj3.zzGG.zzyD;
            n2 = zzhj3.zzGG.zzyE;
        }
        this.zzos.zzqx.zzf(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzos.zzqg == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzos.zzqg.zzGG != null && this.zzos.zzqg.zzGG.zzyw != null) {
            zzp.zzbJ().zza(this.zzos.context, this.zzos.zzqb.zzIz, this.zzos.zzqg, this.zzos.zzpZ, false, zzp.zzbx().zza(this.zzos.context, this.zzos.zzqg.zzGG.zzyw, this.zzos.zzqg.zzDO));
        }
        if (this.zzos.zzqg.zzyQ != null && this.zzos.zzqg.zzyQ.zzyp != null) {
            zzp.zzbJ().zza(this.zzos.context, this.zzos.zzqb.zzIz, this.zzos.zzqg, this.zzos.zzpZ, false, zzp.zzbx().zza(this.zzos.context, this.zzos.zzqg.zzyQ.zzyp, this.zzos.zzqg.zzDO));
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzhj zzhj2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzot != null) {
            adRequestParcel = this.zzot;
            this.zzot = null;
        } else {
            adRequestParcel = zzhj2.zzDy;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzhj2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzhj zzhj2, boolean bl) {
        if (!bl && this.zzos.zzbP()) {
            if (zzhj2.zzyA > 0L) {
                this.zzor.zza(adRequestParcel, zzhj2.zzyA);
            } else if (zzhj2.zzGG != null && zzhj2.zzGG.zzyA > 0L) {
                this.zzor.zza(adRequestParcel, zzhj2.zzGG.zzyA);
            } else if (!zzhj2.zzDX && zzhj2.errorCode == 2) {
                this.zzor.zzf(adRequestParcel);
            }
        }
        return this.zzor.zzbr();
    }

    @Override
    public void pause() {
        zzx.zzch((String)"pause must be called on the main UI thread.");
        if (this.zzos.zzqg != null && this.zzos.zzqg.zzAR != null && this.zzos.zzbP()) {
            zzp.zzbz().zza(this.zzos.zzqg.zzAR.getWebView());
        }
        if (this.zzos.zzqg != null && this.zzos.zzqg.zzyR != null) {
            try {
                this.zzos.zzqg.zzyR.pause();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("Could not pause mediation adapter.");
            }
        }
        this.zzou.zzg(this.zzos.zzqg);
        this.zzor.pause();
    }

    @Override
    public void resume() {
        zzx.zzch((String)"resume must be called on the main UI thread.");
        if (this.zzos.zzqg != null && this.zzos.zzqg.zzAR != null && this.zzos.zzbP()) {
            zzp.zzbz().zzb(this.zzos.zzqg.zzAR.getWebView());
        }
        if (this.zzos.zzqg != null && this.zzos.zzqg.zzyR != null) {
            try {
                this.zzos.zzqg.zzyR.resume();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("Could not resume mediation adapter.");
            }
        }
        this.zzor.resume();
        this.zzou.zzh(this.zzos.zzqg);
    }

    @Override
    protected boolean zzb(AdRequestParcel adRequestParcel) {
        return super.zzb(adRequestParcel) && !this.zzox;
    }

    protected boolean zzaU() {
        boolean bl = true;
        if (!zzp.zzbx().zza(this.zzos.context.getPackageManager(), this.zzos.context.getPackageName(), "android.permission.INTERNET") || !zzp.zzbx().zzI(this.zzos.context)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzaV() {
        this.zzou.zze(this.zzos.zzqg);
        this.zzox = false;
        this.zzaQ();
        this.zzos.zzqi.zzfV();
    }

    @Override
    public void zzaW() {
        this.zzox = true;
        this.zzaS();
    }

    @Override
    public void zzaX() {
        this.onAdClicked();
    }

    @Override
    public void zzaY() {
        this.zzaV();
    }

    @Override
    public void zzaZ() {
        this.zzaO();
    }

    @Override
    public void zzba() {
        this.zzaW();
    }

    @Override
    public void zzbb() {
        if (this.zzos.zzqg != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Mediation adapter " + this.zzos.zzqg.zzyS + " refreshed, but mediation adapters should never refresh.");
        }
        this.zza(this.zzos.zzqg, true);
        this.zzaT();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle) {
        int n;
        Object object;
        Object object2;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzos.context.getApplicationInfo();
        try {
            packageManager = this.zzos.context.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzos.context.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzos.zzqc != null && this.zzos.zzqc.getParent() != null) {
            object2 = new int[2];
            this.zzos.zzqc.getLocationOnScreen((int[])object2);
            Object object3 = object2[0];
            object = object2[1];
            int bl = this.zzos.zzqc.getWidth();
            int l = this.zzos.zzqc.getHeight();
            int n2 = 0;
            if (this.zzos.zzqc.isShown() && object3 + bl > 0 && object + l > 0 && object3 <= packageManager.widthPixels && object <= packageManager.heightPixels) {
                n2 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object3);
            bundle2.putInt("y", (int)object);
            bundle2.putInt("width", bl);
            bundle2.putInt("height", l);
            bundle2.putInt("visible", n2);
        }
        object2 = zzp.zzbA().zzga();
        this.zzos.zzqi = new zzhk((String)object2, this.zzos.zzpZ);
        this.zzos.zzqi.zzh(adRequestParcel);
        String string = zzp.zzbx().zza(this.zzos.context, (View)this.zzos.zzqc, this.zzos.zzqf);
        object = zzm.zzq(this.zzos.context).zzbp();
        boolean bl = zzm.zzq(this.zzos.context).zzbn();
        long l = 0L;
        if (this.zzos.zzqm != null) {
            try {
                l = this.zzos.zzqm.getValue();
            }
            catch (RemoteException string2) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("Cannot get correlation id, default to 0.");
            }
        }
        String string2 = UUID.randomUUID().toString();
        Bundle bundle3 = zzp.zzbA().zza(this.zzos.context, this, (String)object2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzos.zzqs.size(); n += 1) {
            arrayList.add((String)this.zzos.zzqs.keyAt(n));
        }
        n = this.zzos.zzqn != null ? 1 : 0;
        boolean bl2 = this.zzos.zzqo != null && zzp.zzbA().zzgj();
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzos.zzqf, this.zzos.zzpZ, applicationInfo, packageInfo, (String)object2, zzp.zzbA().getSessionId(), this.zzos.zzqb, bundle3, this.zzos.zzqv, arrayList, bundle, zzp.zzbA().zzge(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string, bl, (int)object, l, string2, zzby.zzde(), this.zzos.zzpY, this.zzos.zzqt, new CapabilityParcel(n != 0, bl2));
    }

    @Override
    public void zza(zzfm zzfm2) {
        zzx.zzch((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzos.zzqn = zzfm2;
    }

    @Override
    public void zza(zzfq zzfq2, String string) {
        zzx.zzch((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzos.zzqw = new com.google.android.gms.ads.internal.purchase.zzk(string);
        this.zzos.zzqo = zzfq2;
        if (!zzp.zzbA().zzgd() && zzfq2 != null) {
            new zzc(this.zzos.context, this.zzos.zzqo, this.zzos.zzqw).zzgn();
        }
    }

    @Override
    public void zza(String string, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string, arrayList, this.zzos.context, this.zzos.zzqb.zzIz);
        if (this.zzos.zzqn == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzk.zzcE().zzR(this.zzos.context)) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzos.zzqo == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzos.zzqw == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzos.zzqA) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzos.zzqA = true;
            try {
                if (!this.zzos.zzqo.isValidPurchase(string)) {
                    this.zzos.zzqA = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("Could not start In-App purchase.");
                this.zzos.zzqA = false;
                return;
            }
            zzp.zzbH().zza(this.zzos.context, this.zzos.zzqb.zzIC, new GInAppPurchaseManagerInfoParcel(this.zzos.context, this.zzos.zzqw, zzd2, this));
        } else {
            try {
                this.zzos.zzqn.zza(zzd2);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaE("Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzos.zzqo != null) {
                this.zzos.zzqo.zza(new com.google.android.gms.ads.internal.purchase.zzg(this.zzos.context, string, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Fail to invoke PlayStorePurchaseListener.");
        }
        zzhu.zzHK.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzp.zzbH().zzd(intent);
                zzp.zzbH();
                if (n == 0 && zzb.this.zzos.zzqg != null && zzb.this.zzos.zzqg.zzAR != null && zzb.this.zzos.zzqg.zzAR.zzgQ() != null) {
                    zzb.this.zzos.zzqg.zzAR.zzgQ().close();
                }
                zzb.this.zzos.zzqA = false;
            }
        }, 500L);
    }

    protected void zza(zzhj zzhj2, boolean bl) {
        if (zzhj2 == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaE("Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzhj2);
        if (zzhj2.zzGG != null && zzhj2.zzGG.zzyx != null) {
            zzp.zzbJ().zza(this.zzos.context, this.zzos.zzqb.zzIz, zzhj2, this.zzos.zzpZ, bl, zzp.zzbx().zza(this.zzos.context, zzhj2.zzGG.zzyx, zzhj2.zzDO));
        }
        if (zzhj2.zzyQ != null && zzhj2.zzyQ.zzyq != null) {
            zzp.zzbJ().zza(this.zzos.context, this.zzos.zzqb.zzIz, zzhj2, this.zzos.zzpZ, bl, zzp.zzbx().zza(this.zzos.context, zzhj2.zzyQ.zzyq, zzhj2.zzDO));
        }
    }

    @Override
    public String getMediationAdapterClassName() {
        if (this.zzos.zzqg == null) {
            return null;
        }
        return this.zzos.zzqg.zzyS;
    }

    @Override
    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }
}

