/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzgk;

@zzgk
public class zza {
    public boolean zza(Context context, AdLauncherIntentInfoParcel adLauncherIntentInfoParcel, zzn zzn2) {
        String[] stringArray;
        if (adLauncherIntentInfoParcel == null) {
            zzb.zzaE("No intent data for launcher overlay.");
            return false;
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.url)) {
            zzb.zzaE("Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.mimeType)) {
            intent.setDataAndType(Uri.parse((String)adLauncherIntentInfoParcel.url), adLauncherIntentInfoParcel.mimeType);
        } else {
            intent.setData(Uri.parse((String)adLauncherIntentInfoParcel.url));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.packageName)) {
            intent.setPackage(adLauncherIntentInfoParcel.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.zzzY)) {
            stringArray = adLauncherIntentInfoParcel.zzzY.split("/", 2);
            if (stringArray.length < 2) {
                zzb.zzaE("Could not parse component name from open GMSG: " + adLauncherIntentInfoParcel.zzzY);
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = adLauncherIntentInfoParcel.zzzZ))) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaE("Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        try {
            zzb.v("Launching an intent: " + intent.toURI());
            context.startActivity(intent);
            if (zzn2 != null) {
                zzn2.zzaO();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzaE(activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

