/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int mVersionCode;
    private int zzUS;
    private String zzagU;
    private String zzaoB;
    private Uri zzaqW;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.mVersionCode = 1;
        this.zzUS = gameBadge.getType();
        this.zzagU = gameBadge.getTitle();
        this.zzaoB = gameBadge.getDescription();
        this.zzaqW = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.mVersionCode = versionCode;
        this.zzUS = type;
        this.zzagU = title;
        this.zzaoB = description;
        this.zzaqW = iconImageUri;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getType() {
        return this.zzUS;
    }

    @Override
    public String getTitle() {
        return this.zzagU;
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaqW;
    }

    public GameBadge zzuu() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.zza(this);
    }

    static int zza(GameBadge gameBadge) {
        return zzw.hashCode((Object[])new Object[]{gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri()});
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.zza(this, obj);
    }

    static boolean zza(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return zzw.equal((Object)gameBadge2.getType(), (Object)gameBadge.getTitle()) && zzw.equal((Object)gameBadge2.getDescription(), (Object)gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.zzb(this);
    }

    static String zzb(GameBadge gameBadge) {
        return zzw.zzu((Object)gameBadge).zzg("Type", (Object)gameBadge.getType()).zzg("Title", (Object)gameBadge.getTitle()).zzg("Description", (Object)gameBadge.getDescription()).zzg("IconImageUri", (Object)gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzos()) {
            GameBadgeEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeInt(this.zzUS);
            dest.writeString(this.zzagU);
            dest.writeString(this.zzaoB);
            dest.writeString(this.zzaqW == null ? null : this.zzaqW.toString());
        }
    }

    public /* synthetic */ Object freeze() {
        return this.zzuu();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity zzdP(Parcel parcel) {
            boolean bl = GameBadgeEntity.zzd(GameBadgeEntity.zzor());
            if (bl || GameBadgeEntity.zzcj((String)GameBadgeEntity.class.getCanonicalName())) {
                return super.zzdP(parcel);
            }
            int n = parcel.readInt();
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            return new GameBadgeEntity(1, n, string, string2, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdP(x0);
        }
    }
}

