/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzrx;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class UsageInfo
implements SafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int mVersionCode;
    final DocumentId zzPP;
    final long zzPQ;
    int zzPR;
    public final String zztM;
    final DocumentContents zzPS;
    final boolean zzPT;
    int zzPU;
    int zzPV;

    private UsageInfo(DocumentId documentId, long timestampMs, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this(1, documentId, timestampMs, usageType, query, document, isDeviceOnly, taskPosition, eventStatus);
    }

    public UsageInfo(String packageName, Intent viewIntent, String title, Uri webUrl, String schemaOrgType, List<AppIndexApi.AppIndexingLink> outLinks, int eventStatus) {
        this(1, UsageInfo.zza(packageName, viewIntent), System.currentTimeMillis(), 0, null, UsageInfo.zza(viewIntent, title, webUrl, schemaOrgType, outLinks).zzkY(), false, -1, eventStatus);
    }

    UsageInfo(int versionCode, DocumentId documentId, long timestamp, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this.mVersionCode = versionCode;
        this.zzPP = documentId;
        this.zzPQ = timestamp;
        this.zzPR = usageType;
        this.zztM = query;
        this.zzPS = document;
        this.zzPT = isDeviceOnly;
        this.zzPU = taskPosition;
        this.zzPV = eventStatus;
    }

    public DocumentContents zzle() {
        return this.zzPS;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzp(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzp(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzbA(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzak(1).zzN(true).zzbz("name").zzld(), "text1");
    }

    private static DocumentSection zzi(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzak(4).zzM(true).zzbz("url").zzld());
    }

    private static DocumentSection zzq(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzM(true).zzld(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzh(List<AppIndexApi.AppIndexingLink> list) {
        zznw.zza zza2 = new zznw.zza();
        zznw.zza.zza[] zzaArray = new zznw.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zznw.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].zzaAo = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].zzaAp = appIndexingLink.webUrl.toString();
        }
        zza2.zzaAm = zzaArray;
        return new DocumentSection(zzrx.zzf((zzrx)zza2), new RegisterSectionInfo.zza("outlinks").zzM(true).zzbz(".private:outLinks").zzby("blob").zzld());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzbA(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzi(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzh(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzq("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzq("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzq("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzq("intent_extra_data", string3));
        }
        return zza2.zzbv(string2).zzK(true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", this.zzPP, this.zzPQ, this.zzPR, this.zzPV);
    }

    public static final class zza {
        private DocumentId zzPP;
        private long zzPQ = -1L;
        private int zzPR = -1;
        private String zzJZ;
        private DocumentContents zzPS;
        private boolean zzPT = false;
        private int zzPU = -1;
        private int zzPV = 0;

        public zza zza(DocumentId documentId) {
            this.zzPP = documentId;
            return this;
        }

        public zza zzw(long l) {
            this.zzPQ = l;
            return this;
        }

        public zza zzam(int n) {
            this.zzPR = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.zzPS = documentContents;
            return this;
        }

        public zza zzO(boolean bl) {
            this.zzPT = bl;
            return this;
        }

        public zza zzan(int n) {
            this.zzPV = n;
            return this;
        }

        public UsageInfo zzlf() {
            return new UsageInfo(this.zzPP, this.zzPQ, this.zzPR, this.zzJZ, this.zzPS, this.zzPT, this.zzPU, this.zzPV);
        }
    }
}

