/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_BACKOFF = "RETRY_LATER";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    static Map<String, InstanceID> zzaAO = new HashMap<String, InstanceID>();
    Context mContext;
    private static zzd zzaAP;
    private static zzc zzaAQ;
    KeyPair zzaAR;
    String zzaAS = "";
    long zzaAT;
    static String zzaAU;

    protected InstanceID(Context context, String subtype, Bundle options) {
        this.mContext = context.getApplicationContext();
        this.zzaAS = subtype;
    }

    static int zzaB(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"InstanceID", (String)("Never happens: can't find own package " + (Object)((Object)nameNotFoundException)));
            return 0;
        }
    }

    public static InstanceID getInstance(Context context) {
        return InstanceID.zza(context, null);
    }

    public static synchronized InstanceID zza(Context context, Bundle bundle) {
        String string;
        String string2 = string = bundle == null ? "" : bundle.getString("subtype");
        if (string == null) {
            string = "";
        }
        context = context.getApplicationContext();
        if (zzaAP == null) {
            zzaAP = new zzd(context);
            zzaAQ = new zzc(context);
        }
        zzaAU = Integer.toString(InstanceID.zzaB(context));
        InstanceID instanceID = zzaAO.get(string);
        if (instanceID == null) {
            instanceID = new InstanceID(context, string, bundle);
            zzaAO.put(string, instanceID);
        }
        return instanceID;
    }

    static String zzm(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    KeyPair zzvy() {
        if (this.zzaAR == null) {
            this.zzaAR = zzaAP.zzdr(this.zzaAS);
        }
        if (this.zzaAR == null) {
            this.zzaAT = System.currentTimeMillis();
            this.zzaAR = zzaAP.zze(this.zzaAS, this.zzaAT);
        }
        return this.zzaAR;
    }

    public String getId() {
        return InstanceID.zza(this.zzvy());
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = messageDigest.digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)(n & 0xFF);
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    public long getCreationTime() {
        String string;
        if (this.zzaAT == 0L && (string = zzaAP.get(this.zzaAS, "cre")) != null) {
            this.zzaAT = Long.parseLong(string);
        }
        return this.zzaAT;
    }

    public void deleteInstanceID() throws IOException {
        this.zzb("*", "*", null);
        this.zzvz();
    }

    void zzvz() {
        this.zzaAT = 0L;
        zzaAP.zzds(this.zzaAS);
        this.zzaAR = null;
    }

    public void deleteToken(String authorizedEntity, String scope) throws IOException {
        this.zzb(authorizedEntity, scope, null);
    }

    public void zzb(String string, String string2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzaAP.zzh(this.zzaAS, string, string2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string);
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("subscription", string);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzaAS) ? string : this.zzaAS);
        bundle.putString("X-subtype", "".equals(this.zzaAS) ? string : this.zzaAS);
        Intent intent = zzaAQ.zza(bundle, this.zzvy());
        zzaAQ.zzp(intent);
    }

    zzd zzvA() {
        return zzaAP;
    }

    zzc zzvB() {
        return zzaAQ;
    }

    public String getToken(String authorizedEntity, String scope) throws IOException {
        return this.getToken(authorizedEntity, scope, null);
    }

    public String getToken(String authorizedEntity, String scope, Bundle extras) throws IOException {
        String string;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        boolean bl = true;
        String string2 = string = this.zzvC() ? null : zzaAP.zzg(this.zzaAS, authorizedEntity, scope);
        if (string != null) {
            return string;
        }
        if (extras == null) {
            extras = new Bundle();
        }
        if (extras.getString("ttl") != null) {
            bl = false;
        }
        if ("jwt".equals(extras.getString("type"))) {
            bl = false;
        }
        string = this.zzc(authorizedEntity, scope, extras);
        Log.w((String)"InstanceID", (String)("token: " + string));
        if (string != null && bl) {
            zzaAP.zza(this.zzaAS, authorizedEntity, scope, string, zzaAU);
        }
        return string;
    }

    public String zzc(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        if (string2 != null) {
            bundle.putString("scope", string2);
        }
        bundle.putString("sender", string);
        String string4 = string3 = "".equals(this.zzaAS) ? string : this.zzaAS;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string);
            bundle.putString("subtype", string3);
            bundle.putString("X-subscription", string);
            bundle.putString("X-subtype", string3);
        }
        Intent intent = zzaAQ.zza(bundle, this.zzvy());
        return zzaAQ.zzp(intent);
    }

    boolean zzvC() {
        String string = zzaAP.get("appVersion");
        if (string == null || !string.equals(zzaAU)) {
            return true;
        }
        String string2 = zzaAP.get("lastToken");
        if (string2 == null) {
            return true;
        }
        Long l = Long.parseLong(string2);
        return System.currentTimeMillis() / 1000L - l > 604800L;
    }
}

