/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.MapValue;
import com.google.android.gms.fitness.data.zzt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Value
implements SafeParcelable {
    private final int mVersionCode;
    private final int zzaoq;
    private boolean zzaoG;
    private float zzaou;
    private String zzaoH;
    private Map<String, MapValue> zzaoI;
    private int[] zzaoJ;
    private float[] zzaoK;
    public static final Parcelable.Creator<Value> CREATOR = new zzt();

    public Value(int format) {
        this(3, format, false, 0.0f, null, null, null, null);
    }

    Value(int versionCode, int format, boolean isSet, float value, String stringValue, Bundle mapValue, int[] intArrayValue, float[] floatArrayValue) {
        this.mVersionCode = versionCode;
        this.zzaoq = format;
        this.zzaoG = isSet;
        this.zzaou = value;
        this.zzaoH = stringValue;
        this.zzaoI = Value.zzs(mapValue);
        this.zzaoJ = intArrayValue;
        this.zzaoK = floatArrayValue;
    }

    public void setInt(int value) {
        zzx.zza((this.zzaoq == 1 ? 1 : 0) != 0, (Object)"Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.zzaoG = true;
        this.zzaou = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        zzx.zza((this.zzaoq == 2 ? 1 : 0) != 0, (Object)"Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.zzaoG = true;
        this.zzaou = value;
    }

    public void setString(String value) {
        zzx.zza((this.zzaoq == 3 ? 1 : 0) != 0, (Object)"Attempting to set a string value to a field that is not in STRING format.  Please check the data type definition and use the right format.");
        this.zzaoG = true;
        this.zzaoH = value;
    }

    public void setKeyValue(String key, float value) {
        zzx.zza((this.zzaoq == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        this.zzaoG = true;
        if (this.zzaoI == null) {
            this.zzaoI = new HashMap<String, MapValue>();
        }
        this.zzaoI.put(key, MapValue.zzc(value));
    }

    public void clearKey(String key) {
        zzx.zza((this.zzaoq == 4 ? 1 : 0) != 0, (Object)"Attempting to set a key's value to a field that is not in FLOAT_MAP format.  Please check the data type definition and use the right format.");
        if (this.zzaoI != null) {
            this.zzaoI.remove(key);
        }
    }

    public void setActivity(String activity) {
        this.setInt(FitnessActivities.zzcP(activity));
    }

    public boolean isSet() {
        return this.zzaoG;
    }

    public int getFormat() {
        return this.zzaoq;
    }

    public int asInt() {
        zzx.zza((this.zzaoq == 1 ? 1 : 0) != 0, (Object)"Value is not in int format");
        return Float.floatToRawIntBits(this.zzaou);
    }

    public float asFloat() {
        zzx.zza((this.zzaoq == 2 ? 1 : 0) != 0, (Object)"Value is not in float format");
        return this.zzaou;
    }

    public String asString() {
        zzx.zza((this.zzaoq == 3 ? 1 : 0) != 0, (Object)"Value is not in string format");
        return this.zzaoH;
    }

    public Float getKeyValue(String key) {
        zzx.zza((this.zzaoq == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        if (this.zzaoI != null && this.zzaoI.containsKey(key)) {
            return Float.valueOf(this.zzaoI.get(key).asFloat());
        }
        return null;
    }

    public int[] zzrS() {
        zzx.zza((this.zzaoq == 5 ? 1 : 0) != 0, (Object)"Value is not in int list format");
        return this.zzaoJ;
    }

    public float[] zzrT() {
        zzx.zza((this.zzaoq == 6 ? 1 : 0) != 0, (Object)"Value is not in float list format");
        return this.zzaoK;
    }

    public Map<String, MapValue> zzqX() {
        zzx.zza((this.zzaoq == 4 ? 1 : 0) != 0, (Object)"Value is not in float map format");
        return this.zzaoI == null ? Collections.emptyMap() : this.zzaoI;
    }

    public String asActivity() {
        return FitnessActivities.getName(this.asInt());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Value && this.zza((Value)o);
    }

    private boolean zza(Value value) {
        if (this.zzaoq == value.zzaoq && this.zzaoG == value.zzaoG) {
            switch (this.zzaoq) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
                case 3: {
                    return this.asString().equals(value.asString());
                }
                case 4: {
                    return this.zzqX().equals(value.zzqX());
                }
                case 5: {
                    return this.zzrS().equals(value.zzrS());
                }
                case 6: {
                    return this.zzrT().equals(value.zzrT());
                }
            }
            return this.zzaou == value.zzaou;
        }
        return false;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{Float.valueOf(this.zzaou), this.zzaoH, this.zzaoI, this.zzaoJ, this.zzaoK});
    }

    public String toString() {
        if (!this.zzaoG) {
            return "unset";
        }
        switch (this.zzaoq) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
            case 3: {
                return this.zzaoH;
            }
            case 4: {
                return new TreeMap<String, MapValue>(this.zzaoI).toString();
            }
            case 5: {
                return this.zzrS().toString();
            }
            case 6: {
                return this.zzrT().toString();
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    float zzrM() {
        return this.zzaou;
    }

    String zzrU() {
        return this.zzaoH;
    }

    Bundle zzrV() {
        if (this.zzaoI == null) {
            return null;
        }
        Bundle bundle = new Bundle(this.zzaoI.size());
        for (Map.Entry<String, MapValue> entry : this.zzaoI.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    int[] zzrW() {
        return this.zzaoJ;
    }

    float[] zzrX() {
        return this.zzaoK;
    }

    private static Map<String, MapValue> zzs(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(MapValue.class.getClassLoader());
        ArrayMap arrayMap = new ArrayMap(bundle.size());
        for (String string : bundle.keySet()) {
            arrayMap.put(string, bundle.getParcelable(string));
        }
        return arrayMap;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzt.zza(this, dest, flags);
    }
}

