/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.widget;

import android.content.Context;
import android.database.CursorIndexOutOfBoundsException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.drive.internal.zzy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataBufferAdapter<T>
extends BaseAdapter {
    private final Context mContext;
    private final int zzamI;
    private int zzamJ;
    private final int zzamK;
    private final List<DataBuffer<T>> zzamL;
    private final LayoutInflater mInflater;
    private boolean zzamM = true;

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, List<DataBuffer<T>> objects) {
        this.mContext = context;
        this.zzamI = this.zzamJ = resource;
        this.zzamK = textViewResourceId;
        this.zzamL = objects;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId) {
        this(context, resource, textViewResourceId, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, List<DataBuffer<T>> objects) {
        this(context, resource, 0, objects);
    }

    public DataBufferAdapter(Context context, int resource) {
        this(context, resource, 0, new ArrayList<DataBuffer<T>>());
    }

    public DataBufferAdapter(Context context, int resource, int textViewResourceId, DataBuffer<T> ... buffers) {
        this(context, resource, textViewResourceId, Arrays.asList(buffers));
    }

    public DataBufferAdapter(Context context, int resource, DataBuffer<T> ... buffers) {
        this(context, resource, 0, Arrays.asList(buffers));
    }

    public void append(DataBuffer<T> buffer) {
        this.zzamL.add(buffer);
        if (this.zzamM) {
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        for (DataBuffer<T> dataBuffer : this.zzamL) {
            dataBuffer.release();
        }
        this.zzamL.clear();
        if (this.zzamM) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.zzamM = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.zzamM = notifyOnChange;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getCount() {
        int n = 0;
        for (DataBuffer<T> dataBuffer : this.zzamL) {
            n += dataBuffer.getCount();
        }
        return n;
    }

    public T getItem(int position) throws CursorIndexOutOfBoundsException {
        int n = position;
        for (DataBuffer<T> dataBuffer : this.zzamL) {
            int n2 = dataBuffer.getCount();
            if (n2 <= n) {
                n -= n2;
                continue;
            }
            try {
                return (T)dataBuffer.get(n);
            }
            catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                throw new CursorIndexOutOfBoundsException(position, this.getCount());
            }
        }
        throw new CursorIndexOutOfBoundsException(position, this.getCount());
    }

    public long getItemId(int position) {
        return position;
    }

    private View zza(int n, View view, ViewGroup viewGroup, int n2) {
        TextView textView;
        View view2 = view == null ? this.mInflater.inflate(n2, viewGroup, false) : view;
        try {
            textView = this.zzamK == 0 ? (TextView)view2 : (TextView)view2.findViewById(this.zzamK);
        }
        catch (ClassCastException classCastException) {
            zzy.zza("DataBufferAdapter", classCastException, "You must supply a resource ID for a TextView");
            throw new IllegalStateException("DataBufferAdapter requires the resource ID to be a TextView", classCastException);
        }
        T t = this.getItem(n);
        if (t instanceof CharSequence) {
            textView.setText((CharSequence)t);
        } else {
            textView.setText((CharSequence)t.toString());
        }
        return view2;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.zza(position, convertView, parent, this.zzamI);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.zza(position, convertView, parent, this.zzamJ);
    }

    public void setDropDownViewResource(int resource) {
        this.zzamJ = resource;
    }
}

