/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzd;
import com.google.android.gms.internal.zzlk;
import com.google.android.gms.internal.zzlv;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;

public final class GooglePlayServicesUtil {
    public static final String GMS_ERROR_DIALOG = "GooglePlayServicesErrorDialog";
    @Deprecated
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = GooglePlayServicesUtil.zzmW();
    @Deprecated
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    public static boolean zzYu = false;
    public static boolean zzYv = false;
    private static int zzYw = -1;
    private static final Object zzpm = new Object();
    private static String zzYx = null;
    private static Integer zzYy = null;
    static final AtomicBoolean zzYz = new AtomicBoolean();

    private GooglePlayServicesUtil() {
    }

    private static int zzmW() {
        return 0x7877D8;
    }

    @Deprecated
    public static String getErrorString(int errorCode) {
        return ConnectionResult.getStatusString(errorCode);
    }

    @Deprecated
    public static int isGooglePlayServicesAvailable(Context context) {
        Resources resources;
        if (com.google.android.gms.common.internal.zzd.zzacF) {
            return 0;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            resources = context.getResources();
            resources.getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(context.getPackageName())) {
            GooglePlayServicesUtil.zzad(context);
        }
        try {
            resources = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 1;
        }
        zzd zzd2 = zzd.zzmY();
        if (zzlk.zzbX(resources.versionCode) || zzlk.zzao(context)) {
            if (zzd2.zza((PackageInfo)resources, zzc.zzbu.zzYt) == null) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                return 9;
            }
        } else {
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 64);
                zzc.zza zza2 = zzd2.zza(packageInfo, zzc.zzbu.zzYt);
                if (zza2 == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store signature invalid.");
                    return 9;
                }
                if (zzd2.zza((PackageInfo)resources, zza2) == null) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                    return 9;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if (GooglePlayServicesUtil.zzh(context, GOOGLE_PLAY_STORE_PACKAGE)) {
                    Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is updating.");
                    if (zzd2.zza((PackageInfo)resources, zzc.zzbu.zzYt) == null) {
                        Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services signature invalid.");
                        return 9;
                    }
                }
                Log.w((String)"GooglePlayServicesUtil", (String)"Google Play Store is neither installed nor updating.");
                return 9;
            }
        }
        int n = zzlk.zzbV(GOOGLE_PLAY_SERVICES_VERSION_CODE);
        int n2 = zzlk.zzbV(resources.versionCode);
        if (n2 < n) {
            Log.w((String)"GooglePlayServicesUtil", (String)("Google Play services out of date.  Requires " + GOOGLE_PLAY_SERVICES_VERSION_CODE + " but found " + resources.versionCode));
            return 2;
        }
        ApplicationInfo applicationInfo = resources.applicationInfo;
        if (applicationInfo == null) {
            try {
                applicationInfo = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.wtf((String)"GooglePlayServicesUtil", (String)"Google Play services missing when getting application info.");
                nameNotFoundException.printStackTrace();
                return 1;
            }
        }
        if (!applicationInfo.enabled) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public static void zzaa(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        if (n != 0) {
            Intent intent = GooglePlayServicesUtil.zzbc(n);
            Log.e((String)"GooglePlayServicesUtil", (String)("GooglePlayServices not available due to error " + n));
            if (intent == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            throw new GooglePlayServicesRepairableException(n, "Google Play Services not available", intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzad(Context context) {
        Integer n;
        Object object = zzpm;
        synchronized (object) {
            block11: {
                if (zzYx == null) {
                    zzYx = context.getPackageName();
                    try {
                        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                        Bundle bundle = applicationInfo.metaData;
                        if (bundle != null) {
                            zzYy = bundle.getInt("com.google.android.gms.version");
                            break block11;
                        }
                        zzYy = null;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.wtf((String)"GooglePlayServicesUtil", (String)"This should never happen.", (Throwable)nameNotFoundException);
                    }
                } else if (!zzYx.equals(context.getPackageName())) {
                    throw new IllegalArgumentException("isGooglePlayServicesAvailable should only be called with Context from your application's package. A previous call used package '" + zzYx + "' and this call used package '" + context.getPackageName() + "'.");
                }
            }
            n = zzYy;
        }
        if (n == null) {
            throw new IllegalStateException("A required meta-data tag in your app's AndroidManifest.xml does not exist.  You must have the following declaration within the <application> element:     <meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />");
        }
        if (n != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
            throw new IllegalStateException("The meta-data tag in your app's AndroidManifest.xml does not have the right value.  Expected " + GOOGLE_PLAY_SERVICES_VERSION_CODE + " but" + " found " + n + ".  You must have the" + " following declaration within the <application> element: " + "    <meta-data android:name=\"" + "com.google.android.gms.version" + "\" android:value=\"@integer/google_play_services_version\" />");
        }
    }

    public static boolean zze(Context context, int n) {
        return GooglePlayServicesUtil.zza(context, n, GOOGLE_PLAY_SERVICES_PACKAGE) && GooglePlayServicesUtil.zzb(context.getPackageManager(), GOOGLE_PLAY_SERVICES_PACKAGE);
    }

    public static boolean zza(Context context, int n, String string2) {
        if (zzlv.zzpV()) {
            AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
            try {
                appOpsManager.checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        PackageManager packageManager = context.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean zzb(PackageManager packageManager, String string2) {
        return zzd.zzmY().zzb(packageManager, string2);
    }

    @Deprecated
    public static Intent zzbc(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return zzn.zzcp(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
            case 42: {
                return zzn.zzoM();
            }
            case 3: {
                return zzn.zzcn(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
        }
        return null;
    }

    public static boolean zzmX() {
        if (zzYu) {
            return zzYv;
        }
        return "user".equals(Build.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzb(PackageManager packageManager) {
        Object object = zzpm;
        synchronized (object) {
            if (zzYw == -1) {
                try {
                    PackageInfo packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                    zzYw = zzd.zzmY().zza(packageInfo, zzc.zzYm[1]) != null ? 1 : 0;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzYw = 0;
                }
            }
        }
        return zzYw != 0;
    }

    public static boolean zzc(PackageManager packageManager) {
        return GooglePlayServicesUtil.zzb(packageManager) || !GooglePlayServicesUtil.zzmX();
    }

    private static boolean zzbd(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 18: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static PendingIntent getErrorPendingIntent(int errorCode, Context context, int requestCode) {
        Intent intent = GooglePlayServicesUtil.zzbc(errorCode);
        if (intent == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent, (int)0x10000000);
    }

    @Deprecated
    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.getErrorDialog(errorCode, activity, requestCode, null);
    }

    @Deprecated
    public static Dialog getErrorDialog(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.zza(errorCode, activity, null, requestCode, cancelListener);
    }

    private static Dialog zza(int n, Activity activity, Fragment fragment, int n2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        String string3;
        Object object;
        if (n == 0) {
            return null;
        }
        if (zzlk.zzao((Context)activity) && n == 2) {
            n = 42;
        }
        AlertDialog.Builder builder = null;
        if (zzlv.zzpR()) {
            object = new TypedValue();
            activity.getTheme().resolveAttribute(16843529, object, true);
            string3 = activity.getResources().getResourceEntryName(object.resourceId);
            if ("Theme.Dialog.Alert".equals(string3)) {
                builder = new AlertDialog.Builder((Context)activity, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder((Context)activity);
        }
        object = GooglePlayServicesUtil.zzaf((Context)activity);
        builder.setMessage((CharSequence)zzg.zzb((Context)activity, n, (String)object));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        string3 = GooglePlayServicesUtil.zzbc(n);
        zzh zzh2 = fragment == null ? new zzh(activity, (Intent)string3, n2) : new zzh(fragment, (Intent)string3, n2);
        String string4 = zzg.zzh((Context)activity, n);
        if (string4 != null) {
            builder.setPositiveButton((CharSequence)string4, (DialogInterface.OnClickListener)zzh2);
        }
        if ((string2 = zzg.zzg((Context)activity, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, null, requestCode, cancelListener);
    }

    public static boolean showErrorDialogFragment(int errorCode, Activity activity, Fragment fragment, int requestCode, DialogInterface.OnCancelListener cancelListener) {
        boolean bl;
        Dialog dialog = GooglePlayServicesUtil.zza(errorCode, activity, fragment, requestCode, cancelListener);
        if (dialog == null) {
            return false;
        }
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, cancelListener);
            supportErrorDialogFragment.show(fragmentManager, GMS_ERROR_DIALOG);
        } else if (zzlv.zzpO()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, cancelListener);
            errorDialogFragment.show(fragmentManager, GMS_ERROR_DIALOG);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
        return true;
    }

    @Deprecated
    public static void showErrorNotification(int errorCode, Context context) {
        if (zzlk.zzao(context) && errorCode == 2) {
            errorCode = 42;
        }
        if (GooglePlayServicesUtil.zzd(context, errorCode) || GooglePlayServicesUtil.zzf(context, errorCode)) {
            GooglePlayServicesUtil.zzae(context);
        } else {
            GooglePlayServicesUtil.zza(errorCode, context);
        }
    }

    private static void zzae(Context context) {
        zza zza2 = new zza(context);
        zza2.sendMessageDelayed(zza2.obtainMessage(1), 120000L);
    }

    private static void zza(int n, Context context) {
        GooglePlayServicesUtil.zza(n, context, null);
    }

    private static void zza(int n, Context context, String string2) {
        int n2;
        Notification.Builder builder;
        Notification notification;
        String string3;
        Resources resources = context.getResources();
        String string4 = GooglePlayServicesUtil.zzaf(context);
        String string5 = zzg.zzi(context, n);
        if (string5 == null) {
            string5 = resources.getString(R.string.common_google_play_services_notification_ticker);
        }
        String string6 = zzg.zzc(context, n, string4);
        PendingIntent pendingIntent = GooglePlayServicesUtil.getErrorPendingIntent(n, context, 0);
        if (zzlk.zzao(context)) {
            zzx.zzY(zzlv.zzpS());
            string3 = new Notification.Builder(context).setSmallIcon(R.drawable.common_ic_googleplayservices).setPriority(2).setAutoCancel(true).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)(string5 + " " + string6))).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            notification = string3.build();
        } else {
            string3 = resources.getString(R.string.common_google_play_services_notification_ticker);
            if (zzlv.zzpO()) {
                builder = new Notification.Builder(context).setSmallIcon(17301642).setContentTitle((CharSequence)string5).setContentText((CharSequence)string6).setContentIntent(pendingIntent).setTicker((CharSequence)string3).setAutoCancel(true);
                if (zzlv.zzpW()) {
                    builder.setLocalOnly(true);
                }
                if (zzlv.zzpS()) {
                    builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string6));
                    notification = builder.build();
                } else {
                    notification = builder.getNotification();
                }
                if (Build.VERSION.SDK_INT == 19) {
                    notification.extras.putBoolean("android.support.localOnly", true);
                }
            } else {
                notification = new Notification(17301642, (CharSequence)string3, System.currentTimeMillis());
                notification.flags |= 0x10;
                notification.setLatestEventInfo(context, (CharSequence)string5, (CharSequence)string6, pendingIntent);
            }
        }
        if (GooglePlayServicesUtil.zzbd(n)) {
            n2 = 10436;
            zzYz.set(false);
        } else {
            n2 = 39789;
        }
        builder = (NotificationManager)context.getSystemService("notification");
        if (string2 != null) {
            builder.notify(string2, n2, notification);
        } else {
            builder.notify(n2, notification);
        }
    }

    @Deprecated
    public static void zzac(Context context) {
        if (zzYz.getAndSet(true)) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.cancel(10436);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Deprecated
    public static boolean showErrorDialogFragment(int errorCode, Activity activity, int requestCode) {
        return GooglePlayServicesUtil.showErrorDialogFragment(errorCode, activity, requestCode, null);
    }

    @Deprecated
    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        String string2;
        block9: {
            Uri uri = new Uri.Builder().scheme("android.resource").authority(GOOGLE_PLAY_SERVICES_PACKAGE).appendPath("raw").appendPath("oss_notice").build();
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            try {
                string2 = new Scanner(inputStream).useDelimiter("\\A").next();
                if (inputStream == null) break block9;
            }
            catch (NoSuchElementException noSuchElementException) {
                String string3;
                block10: {
                    try {
                        string3 = null;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return string3;
            }
            inputStream.close();
        }
        return string2;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static Context getRemoteContext(Context context) {
        try {
            return context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static String zzaf(Context context) {
        String string2 = context.getApplicationInfo().name;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            ApplicationInfo applicationInfo;
            string2 = context.getPackageName();
            PackageManager packageManager = context.getApplicationContext().getPackageManager();
            try {
                applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                applicationInfo = null;
            }
            if (applicationInfo != null) {
                string2 = packageManager.getApplicationLabel(applicationInfo).toString();
            }
        }
        return string2;
    }

    public static boolean zzag(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return zzlv.zzpX() && packageManager.hasSystemFeature("com.google.sidewinder");
    }

    @Deprecated
    public static boolean zzd(Context context, int n) {
        if (n == 18) {
            return true;
        }
        if (n == 1) {
            return GooglePlayServicesUtil.zzh(context, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    public static boolean zzf(Context context, int n) {
        if (n == 9) {
            return GooglePlayServicesUtil.zzh(context, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    public static boolean zzh(Context context, String string2) {
        if (zzlv.zzpX()) {
            List list = context.getPackageManager().getPackageInstaller().getAllSessions();
            for (PackageInstaller.SessionInfo sessionInfo : list) {
                if (!string2.equals(sessionInfo.getAppPackageName())) continue;
                return true;
            }
        } else {
            PackageManager packageManager = context.getPackageManager();
            try {
                if (packageManager.getApplicationInfo((String)string2, (int)8192).enabled) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private static class zza
    extends Handler {
        private final Context zzqO;

        zza(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zzqO = context.getApplicationContext();
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.zzqO);
                    if (!GooglePlayServicesUtil.isUserRecoverableError(n)) break;
                    GooglePlayServicesUtil.zza(n, this.zzqO);
                    break;
                }
                default: {
                    Log.w((String)"GooglePlayServicesUtil", (String)("Don't know how to handle this message: " + msg.what));
                }
            }
        }
    }
}

