/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.stats.WakeLockEvent;
import com.google.android.gms.common.stats.zzc;
import com.google.android.gms.common.stats.zzd;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlv;
import java.util.List;

public class zzh {
    private static String TAG = "WakeLockTracker";
    private static zzh zzaga = new zzh();
    private static final ComponentName zzafz = new ComponentName("com.google.android.gms", "com.google.android.gms.common.stats.GmsCoreStatsService");
    private static IntentFilter zzagb = new IntentFilter("android.intent.action.BATTERY_CHANGED");
    private static Integer zzafB;

    public static zzh zzpL() {
        return zzaga;
    }

    public void zza(Context context, String string2, int n, String string3, String string4, int n2, List<String> list) {
        if (!zzh.zzan(context)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.e((String)TAG, (String)("missing wakeLock key. " + string2));
            return;
        }
        long l = System.currentTimeMillis();
        if (7 == n || 8 == n || 10 == n || 11 == n) {
            WakeLockEvent wakeLockEvent = new WakeLockEvent(l, n, string3, n2, list, string2, SystemClock.elapsedRealtime(), this.zzal(context), string4, context.getPackageName(), this.zzam(context));
            try {
                context.startService(new Intent().setComponent(zzafz).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)wakeLockEvent));
            }
            catch (Exception exception) {
                Log.wtf((String)TAG, (Throwable)exception);
            }
        }
    }

    private int zzal(Context context) {
        Intent intent = context.getApplicationContext().registerReceiver(null, zzagb);
        int n = intent == null ? 0 : intent.getIntExtra("plugged", 0);
        boolean bl = (7 & n) != 0;
        boolean bl2 = zzlv.zzpW() ? ((PowerManager)context.getSystemService("power")).isInteractive() : ((PowerManager)context.getSystemService("power")).isScreenOn();
        return (bl2 ? 1 : 0) << 1 | (bl ? 1 : 0);
    }

    private float zzam(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.getApplicationContext().registerReceiver(null, intentFilter);
        float f = Float.NaN;
        if (intent != null) {
            int n = intent.getIntExtra("level", -1);
            int n2 = intent.getIntExtra("scale", -1);
            f = (float)n / (float)n2;
        }
        return f;
    }

    private static boolean zzan(Context context) {
        if (zzafB == null) {
            zzafB = zzh.getLogLevel();
        }
        return zzafB != zzd.LOG_LEVEL_OFF;
    }

    private static int getLogLevel() {
        try {
            return zzll.zzjk() ? zzc.zzb.zzafD.get() : zzd.LOG_LEVEL_OFF;
        }
        catch (SecurityException securityException) {
            return zzd.LOG_LEVEL_OFF;
        }
    }
}

