/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zze;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
implements SafeParcelable {
    public static final zze CREATOR = new zze();
    public static final PasswordSpecification zzRo = new zza().zzh(12, 16).zzbD("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zzf("abcdefghijkmnopqrstxyz", 1).zzf("ABCDEFGHJKLMNPQRSTXY", 1).zzf("3456789", 1).zzlx();
    public static final PasswordSpecification zzRp = new zza().zzh(12, 16).zzbD("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zzf("abcdefghijklmnopqrstuvwxyz", 1).zzf("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zzf("1234567890", 1).zzlx();
    final int mVersionCode;
    final String zzRq;
    final List<String> zzRr;
    final List<Integer> zzRs;
    final int zzRt;
    final int zzRu;
    private final int[] zzRv;
    private final Random zzsT;

    PasswordSpecification(int version, String allowedChars, List<String> requiredCharSets, List<Integer> requiredCharCounts, int minimumSize, int maximumSize) {
        this.mVersionCode = version;
        this.zzRq = allowedChars;
        this.zzRr = Collections.unmodifiableList(requiredCharSets);
        this.zzRs = Collections.unmodifiableList(requiredCharCounts);
        this.zzRt = minimumSize;
        this.zzRu = maximumSize;
        this.zzRv = this.zzlw();
        this.zzsT = new SecureRandom();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    private int[] zzlw() {
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (String string2 : this.zzRr) {
            for (char c : string2.toCharArray()) {
                nArray[this.zza((char)c)] = n;
            }
            ++n;
        }
        return nArray;
    }

    private int zza(char c) {
        return c - 32;
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzb(int n, int n2, int n3) {
        return n < n2 || n > n3;
    }

    public static class zzb
    extends Error {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final TreeSet<Character> zzRw = new TreeSet();
        private final List<String> zzRr = new ArrayList<String>();
        private final List<Integer> zzRs = new ArrayList<Integer>();
        private int zzRt = 12;
        private int zzRu = 16;

        public zza zzbD(String string2) {
            this.zzRw.addAll(this.zzr(string2, "allowedChars"));
            return this;
        }

        public zza zzf(String string2, int n) {
            if (n < 1) {
                throw new zzb("count must be at least 1");
            }
            TreeSet<Character> treeSet = this.zzr(string2, "requiredChars");
            this.zzRr.add(PasswordSpecification.zzb(treeSet));
            this.zzRs.add(n);
            return this;
        }

        public zza zzh(int n, int n2) {
            if (n < 1) {
                throw new zzb("minimumSize must be at least 1");
            }
            if (n > n2) {
                throw new zzb("maximumSize must be greater than or equal to minimumSize");
            }
            this.zzRt = n;
            this.zzRu = n2;
            return this;
        }

        public PasswordSpecification zzlx() {
            if (this.zzRw.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            this.zzly();
            this.zzlz();
            return new PasswordSpecification(1, PasswordSpecification.zzb(this.zzRw), this.zzRr, this.zzRs, this.zzRt, this.zzRu);
        }

        private TreeSet<Character> zzr(String string2, String string3) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new zzb(string3 + " cannot be null or empty");
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string2.toCharArray()) {
                if (PasswordSpecification.zzb(c, 32, 126)) {
                    throw new zzb(string3 + " must only contain ASCII printable characters");
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }

        private void zzly() {
            int n = 0;
            for (int n2 : this.zzRs) {
                n += n2;
            }
            if (n > this.zzRu) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
        }

        private void zzlz() {
            boolean[] blArray = new boolean[95];
            for (String string2 : this.zzRr) {
                for (char c : string2.toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb("character " + c + " occurs in more than one required character set");
                    }
                    blArray[c - 32] = true;
                }
            }
        }
    }
}

