/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzbn;
import com.google.android.gms.wearable.internal.zzh;
import com.google.android.gms.wearable.internal.zzk;
import com.google.android.gms.wearable.internal.zzn;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelImpl
implements SafeParcelable,
Channel {
    public static final Parcelable.Creator<ChannelImpl> CREATOR = new zzn();
    final int mVersionCode;
    private final String zzaZM;
    private final String zzaYR;
    private final String mPath;

    ChannelImpl(int versionCode, String token, String nodeId, String path) {
        this.mVersionCode = versionCode;
        this.zzaZM = (String)zzx.zzv((Object)token);
        this.zzaYR = (String)zzx.zzv((Object)nodeId);
        this.mPath = (String)zzx.zzv((Object)path);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzn.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelImpl{versionCode=" + this.mVersionCode + ", token='" + this.zzaZM + '\'' + ", nodeId='" + this.zzaYR + '\'' + ", path='" + this.mPath + '\'' + "}";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl channelImpl = (ChannelImpl)other;
        return this.zzaZM.equals(channelImpl.zzaZM) && zzw.equal((Object)channelImpl.zzaYR, (Object)this.zzaYR) && zzw.equal((Object)channelImpl.mPath, (Object)this.mPath) && channelImpl.mVersionCode == this.mVersionCode;
    }

    public int hashCode() {
        return this.zzaZM.hashCode();
    }

    @Override
    public String getNodeId() {
        return this.zzaYR;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    public String getToken() {
        return this.zzaZM;
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client) {
        return client.zzb((zzc.zza)new zzh<Status>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zzt((zzc.zzb<Status>)this, ChannelImpl.this.zzaZM);
            }

            protected Status zzd(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client, final int errorCode) {
        return client.zzb((zzc.zza)new zzh<Status>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zzh((zzc.zzb<Status>)this, ChannelImpl.this.zzaZM, errorCode);
            }

            protected Status zzd(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient client) {
        return client.zzb((zzc.zza)new zzh<Channel.GetInputStreamResult>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zzu((zzc.zzb<Channel.GetInputStreamResult>)this, ChannelImpl.this.zzaZM);
            }

            public Channel.GetInputStreamResult zzbn(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzbn(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient client) {
        return client.zzb((zzc.zza)new zzh<Channel.GetOutputStreamResult>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zzv((zzc.zzb<Channel.GetOutputStreamResult>)this, ChannelImpl.this.zzaZM);
            }

            public Channel.GetOutputStreamResult zzbo(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzbo(status);
            }
        });
    }

    @Override
    public PendingResult<Status> receiveFile(GoogleApiClient client, final Uri uri, final boolean append) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)uri, (Object)"uri is null");
        return client.zzb((zzc.zza)new zzh<Status>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zza((zzc.zzb<Status>)this, ChannelImpl.this.zzaZM, uri, append);
            }

            public Status zzd(Status status) {
                return status;
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, Uri uri) {
        return this.sendFile(client, uri, 0L, -1L);
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, final Uri uri, final long startOffset, final long length) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)this.zzaZM, (Object)"token is null");
        zzx.zzb((Object)uri, (Object)"uri is null");
        zzx.zzb((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{startOffset});
        zzx.zzb((length >= 0L || length == -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{length});
        return client.zzb((zzc.zza)new zzh<Status>(client){

            protected void zza(zzbn zzbn2) throws RemoteException {
                zzbn2.zza((zzc.zzb<Status>)this, ChannelImpl.this.zzaZM, uri, startOffset, length);
            }

            public Status zzd(Status status) {
                return status;
            }

            public /* synthetic */ Result zzb(Status status) {
                return this.zzd(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)listener, (Object)"listener is null");
        return client.zza((zzc.zza)new zzk.zza(client, listener, this.zzaZM));
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)listener, (Object)"listener is null");
        return client.zza((zzc.zza)new zzk.zzc(client, listener, this.zzaZM));
    }

    static final class zzb
    implements Channel.GetOutputStreamResult {
        private final Status zzQA;
        private final OutputStream zzaZX;

        zzb(Status status, OutputStream outputStream) {
            this.zzQA = (Status)zzx.zzv((Object)status);
            this.zzaZX = outputStream;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.zzaZX;
        }

        public void release() {
            if (this.zzaZX != null) {
                try {
                    this.zzaZX.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static final class zza
    implements Channel.GetInputStreamResult {
        private final Status zzQA;
        private final InputStream zzaZW;

        zza(Status status, InputStream inputStream) {
            this.zzQA = (Status)zzx.zzv((Object)status);
            this.zzaZW = inputStream;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public InputStream getInputStream() {
            return this.zzaZW;
        }

        public void release() {
            if (this.zzaZW != null) {
                try {
                    this.zzaZW.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

