/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.appstate.AppStateBuffer;
import com.google.android.gms.appstate.AppStateManager;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzjp;
import java.util.Set;

public final class zzjn
extends zzj<zzjp> {
    public zzjn(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 7, zzf2, connectionCallbacks, onConnectionFailedListener);
    }

    public boolean zzlm() {
        return true;
    }

    protected Set<Scope> zza(Set<Scope> set) {
        zzx.zza((boolean)set.contains(new Scope("https://www.googleapis.com/auth/appstate")), (Object)String.format("App State APIs requires %s to function.", "https://www.googleapis.com/auth/appstate"));
        return set;
    }

    protected String zzfA() {
        return "com.google.android.gms.appstate.service.START";
    }

    protected String zzfB() {
        return "com.google.android.gms.appstate.internal.IAppStateService";
    }

    protected zzjp zzal(IBinder iBinder) {
        return zzjp.zza.zzan(iBinder);
    }

    public int zzln() {
        int n = 2;
        try {
            n = ((zzjp)this.zzoA()).zzln();
        }
        catch (RemoteException remoteException) {
            Log.w((String)"AppStateClient", (String)"service died");
        }
        return n;
    }

    public int zzlo() {
        int n = 2;
        try {
            n = ((zzjp)this.zzoA()).zzlo();
        }
        catch (RemoteException remoteException) {
            Log.w((String)"AppStateClient", (String)"service died");
        }
        return n;
    }

    public void zza(zzc.zzb<AppStateManager.StateResult> zzb2, int n, byte[] byArray) throws RemoteException {
        zze zze2 = zzb2 == null ? null : new zze(zzb2);
        ((zzjp)this.zzoA()).zza(zze2, n, byArray);
    }

    public void zza(zzc.zzb<AppStateManager.StateDeletedResult> zzb2, int n) throws RemoteException {
        ((zzjp)this.zzoA()).zzb(new zza(zzb2), n);
    }

    public void zzb(zzc.zzb<AppStateManager.StateResult> zzb2, int n) throws RemoteException {
        ((zzjp)this.zzoA()).zza(new zze(zzb2), n);
    }

    public void zza(zzc.zzb<AppStateManager.StateListResult> zzb2) throws RemoteException {
        ((zzjp)this.zzoA()).zza(new zzc(zzb2));
    }

    public void zza(zzc.zzb<AppStateManager.StateResult> zzb2, int n, String string, byte[] byArray) throws RemoteException {
        ((zzjp)this.zzoA()).zza(new zze(zzb2), n, string, byArray);
    }

    public void zzb(zzc.zzb<Status> zzb2) throws RemoteException {
        ((zzjp)this.zzoA()).zzb(new zzg(zzb2));
    }

    protected /* synthetic */ IInterface zzV(IBinder iBinder) {
        return this.zzal(iBinder);
    }

    private static final class zzb
    implements AppStateManager.StateDeletedResult {
        private final Status zzQA;
        private final int zzQB;

        public zzb(Status status, int n) {
            this.zzQA = status;
            this.zzQB = n;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public int getStateKey() {
            return this.zzQB;
        }
    }

    private static final class zzd
    extends com.google.android.gms.common.api.zze
    implements AppStateManager.StateListResult {
        private final AppStateBuffer zzQC;

        public zzd(DataHolder dataHolder) {
            super(dataHolder);
            this.zzQC = new AppStateBuffer(dataHolder);
        }

        @Override
        public AppStateBuffer getStateBuffer() {
            return this.zzQC;
        }
    }

    private static final class zzf
    extends com.google.android.gms.common.api.zze
    implements AppStateManager.StateConflictResult,
    AppStateManager.StateLoadedResult,
    AppStateManager.StateResult {
        private final int zzQB;
        private final AppStateBuffer zzQC;

        public zzf(int n, DataHolder dataHolder) {
            super(dataHolder);
            this.zzQB = n;
            this.zzQC = new AppStateBuffer(dataHolder);
        }

        @Override
        public String getResolvedVersion() {
            if (this.zzQC.getCount() == 0) {
                return null;
            }
            return this.zzQC.get(0).getConflictVersion();
        }

        @Override
        public byte[] getServerData() {
            if (this.zzQC.getCount() == 0) {
                return null;
            }
            return this.zzQC.get(0).getConflictData();
        }

        @Override
        public int getStateKey() {
            return this.zzQB;
        }

        @Override
        public byte[] getLocalData() {
            if (this.zzQC.getCount() == 0) {
                return null;
            }
            return this.zzQC.get(0).getLocalData();
        }

        private boolean zzlp() {
            return this.zzQA.getStatusCode() == 2000;
        }

        @Override
        public AppStateManager.StateLoadedResult getLoadedResult() {
            return this.zzlp() ? null : this;
        }

        @Override
        public AppStateManager.StateConflictResult getConflictResult() {
            return this.zzlp() ? this : null;
        }

        public void release() {
            this.zzQC.release();
        }
    }

    private static final class zzg
    extends zzjm {
        private final zzc.zzb<Status> zzQz;

        public zzg(zzc.zzb<Status> zzb2) {
            this.zzQz = (zzc.zzb)zzx.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzll() {
            Status status = new Status(0);
            this.zzQz.zzn((Object)status);
        }
    }

    private static final class zza
    extends zzjm {
        private final zzc.zzb<AppStateManager.StateDeletedResult> zzQz;

        public zza(zzc.zzb<AppStateManager.StateDeletedResult> zzb2) {
            this.zzQz = (zzc.zzb)zzx.zzb(zzb2, (Object)"Result holder must not be null");
        }

        @Override
        public void zzg(int n, int n2) {
            Status status = new Status(n);
            this.zzQz.zzn((Object)new zzb(status, n2));
        }
    }

    private static final class zzc
    extends zzjm {
        private final zzc.zzb<AppStateManager.StateListResult> zzQz;

        public zzc(zzc.zzb<AppStateManager.StateListResult> zzb2) {
            this.zzQz = (zzc.zzb)zzx.zzb(zzb2, (Object)"Result holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder) {
            this.zzQz.zzn((Object)new zzd(dataHolder));
        }
    }

    private static final class zze
    extends zzjm {
        private final zzc.zzb<AppStateManager.StateResult> zzQz;

        public zze(zzc.zzb<AppStateManager.StateResult> zzb2) {
            this.zzQz = (zzc.zzb)zzx.zzb(zzb2, (Object)"Result holder must not be null");
        }

        @Override
        public void zza(int n, DataHolder dataHolder) {
            this.zzQz.zzn((Object)new zzf(n, dataHolder));
        }
    }
}

