/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v7.preference.Preference;
import android.support.v7.preference.R;
import android.text.TextUtils;
import android.util.AttributeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PreferenceGroup
extends Preference {
    private List<Preference> mPreferenceList = new ArrayList<Preference>();
    private boolean mOrderingAsAdded = true;
    private int mCurrentPreferenceOrder = 0;
    private boolean mAttachedToHierarchy = false;

    public PreferenceGroup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PreferenceGroup, defStyleAttr, defStyleRes);
        this.mOrderingAsAdded = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.PreferenceGroup_orderingFromXml, (int)R.styleable.PreferenceGroup_orderingFromXml, (boolean)true);
        a.recycle();
    }

    public PreferenceGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public PreferenceGroup(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public void setOrderingAsAdded(boolean orderingAsAdded) {
        this.mOrderingAsAdded = orderingAsAdded;
    }

    public boolean isOrderingAsAdded() {
        return this.mOrderingAsAdded;
    }

    public void addItemFromInflater(Preference preference) {
        this.addPreference(preference);
    }

    public int getPreferenceCount() {
        return this.mPreferenceList.size();
    }

    public Preference getPreference(int index) {
        return this.mPreferenceList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPreference(Preference preference) {
        int insertionIndex;
        if (this.mPreferenceList.contains(preference)) {
            return true;
        }
        if (preference.getOrder() == Integer.MAX_VALUE) {
            if (this.mOrderingAsAdded) {
                preference.setOrder(this.mCurrentPreferenceOrder++);
            }
            if (preference instanceof PreferenceGroup) {
                ((PreferenceGroup)preference).setOrderingAsAdded(this.mOrderingAsAdded);
            }
        }
        if ((insertionIndex = Collections.binarySearch(this.mPreferenceList, preference)) < 0) {
            insertionIndex = insertionIndex * -1 - 1;
        }
        if (!this.onPrepareAddPreference(preference)) {
            return false;
        }
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            this.mPreferenceList.add(insertionIndex, preference);
        }
        preference.onAttachedToHierarchy(this.getPreferenceManager());
        if (this.mAttachedToHierarchy) {
            preference.onAttached();
        }
        this.notifyHierarchyChanged();
        return true;
    }

    public boolean removePreference(Preference preference) {
        boolean returnValue = this.removePreferenceInt(preference);
        this.notifyHierarchyChanged();
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePreferenceInt(Preference preference) {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            preference.onPrepareForRemoval();
            return this.mPreferenceList.remove(preference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            List<Preference> preferenceList = this.mPreferenceList;
            for (int i = preferenceList.size() - 1; i >= 0; --i) {
                this.removePreferenceInt(preferenceList.get(0));
            }
        }
        this.notifyHierarchyChanged();
    }

    protected boolean onPrepareAddPreference(Preference preference) {
        preference.onParentChanged(this, this.shouldDisableDependents());
        return true;
    }

    public Preference findPreference(CharSequence key) {
        if (TextUtils.equals((CharSequence)this.getKey(), (CharSequence)key)) {
            return this;
        }
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            Preference returnedPreference;
            Preference preference = this.getPreference(i);
            String curKey = preference.getKey();
            if (curKey != null && curKey.equals(key)) {
                return preference;
            }
            if (!(preference instanceof PreferenceGroup) || (returnedPreference = ((PreferenceGroup)preference).findPreference(key)) == null) continue;
            return returnedPreference;
        }
        return null;
    }

    protected boolean isOnSameScreenAsChildren() {
        return true;
    }

    @Override
    public void onAttached() {
        super.onAttached();
        this.mAttachedToHierarchy = true;
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onAttached();
        }
    }

    @Override
    protected void onPrepareForRemoval() {
        super.onPrepareForRemoval();
        this.mAttachedToHierarchy = false;
    }

    @Override
    public void notifyDependencyChange(boolean disableDependents) {
        super.notifyDependencyChange(disableDependents);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onParentChanged(this, disableDependents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sortPreferences() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            Collections.sort(this.mPreferenceList);
        }
    }

    @Override
    protected void dispatchSaveInstanceState(Bundle container) {
        super.dispatchSaveInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchSaveInstanceState(container);
        }
    }

    @Override
    protected void dispatchRestoreInstanceState(Bundle container) {
        super.dispatchRestoreInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchRestoreInstanceState(container);
        }
    }
}

