/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.preference.DialogPreference;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.TextView;

public abstract class PreferenceDialogFragmentCompat
extends DialogFragment
implements DialogInterface.OnClickListener {
    protected static final String ARG_KEY = "key";
    private DialogPreference mPreference;
    private int mWhichButtonClicked;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Fragment rawFragment = this.getTargetFragment();
        if (!(rawFragment instanceof DialogPreference.TargetFragment)) {
            throw new IllegalStateException("Target fragment must implement TargetFragment interface");
        }
        DialogPreference.TargetFragment fragment = (DialogPreference.TargetFragment)rawFragment;
        String key = this.getArguments().getString(ARG_KEY);
        this.mPreference = (DialogPreference)fragment.findPreference(key);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity context = this.getActivity();
        this.mWhichButtonClicked = -2;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context).setTitle(this.mPreference.getDialogTitle()).setIcon(this.mPreference.getDialogIcon()).setPositiveButton(this.mPreference.getPositiveButtonText(), (DialogInterface.OnClickListener)this).setNegativeButton(this.mPreference.getNegativeButtonText(), (DialogInterface.OnClickListener)this);
        View contentView = this.onCreateDialogView((Context)context);
        if (contentView != null) {
            this.onBindDialogView(contentView);
            builder.setView(contentView);
        } else {
            builder.setMessage(this.mPreference.getDialogMessage());
        }
        this.onPrepareDialogBuilder(builder);
        AlertDialog dialog = builder.create();
        if (this.needInputMethod()) {
            this.requestInputMethod((Dialog)dialog);
        }
        return builder.create();
    }

    public DialogPreference getPreference() {
        return this.mPreference;
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
    }

    protected boolean needInputMethod() {
        return false;
    }

    private void requestInputMethod(Dialog dialog) {
        Window window = dialog.getWindow();
        window.setSoftInputMode(5);
    }

    protected View onCreateDialogView(Context context) {
        int resId = this.mPreference.getDialogLayoutResource();
        if (resId == 0) {
            return null;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        return inflater.inflate(resId, null);
    }

    protected void onBindDialogView(View view) {
        View dialogMessageView = view.findViewById(16908299);
        if (dialogMessageView != null) {
            CharSequence message = this.mPreference.getDialogMessage();
            int newVisibility = 8;
            if (!TextUtils.isEmpty((CharSequence)message)) {
                if (dialogMessageView instanceof TextView) {
                    ((TextView)dialogMessageView).setText(message);
                }
                newVisibility = 0;
            }
            if (dialogMessageView.getVisibility() != newVisibility) {
                dialogMessageView.setVisibility(newVisibility);
            }
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        this.mWhichButtonClicked = which;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        this.onDialogClosed(this.mWhichButtonClicked == -1);
    }

    public abstract void onDialogClosed(boolean var1);
}

