/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzs;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class zzv
implements com.google.android.gms.internal.zzb {
    private final Map<String, zza> zzax = new LinkedHashMap<String, zza>(16, 0.75f, true);
    private long zzay = 0L;
    private final File zzaz;
    private final int zzaA;

    public zzv(File file, int n) {
        this.zzaz = file;
        this.zzaA = n;
    }

    public zzv(File file) {
        this(file, 0x500000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized zzb.zza zza(String string2) {
        zza zza2 = this.zzax.get(string2);
        if (zza2 == null) {
            return null;
        }
        File file = this.zzf(string2);
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new zzb(new FileInputStream(file));
            zza.zzf(filterInputStream);
            byte[] byArray = zzv.zza(filterInputStream, (int)(file.length() - (long)((zzb)filterInputStream).zzaC));
            zzb.zza zza3 = zza2.zzb(byArray);
            return zza3;
        }
        catch (IOException iOException) {
            zzs.zzb("%s: %s", file.getAbsolutePath(), iOException.toString());
            this.remove(string2);
            zzb.zza zza4 = null;
            return zza4;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void zza() {
        if (!this.zzaz.exists()) {
            if (!this.zzaz.mkdirs()) {
                zzs.zzc("Unable to create cache dir %s", this.zzaz.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.zzaz.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                zza zza2 = zza.zzf(bufferedInputStream);
                zza2.zzaB = file.length();
                this.zza(zza2.key, zza2);
            }
            catch (IOException iOException) {
                if (file == null) continue;
                file.delete();
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public synchronized void zza(String string2, zzb.zza zza2) {
        this.zzc(zza2.data.length);
        File file = this.zzf(string2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            zza zza3 = new zza(string2, zza2);
            boolean bl = zza3.zza(fileOutputStream);
            if (!bl) {
                fileOutputStream.close();
                zzs.zzb("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            fileOutputStream.write(zza2.data);
            fileOutputStream.close();
            this.zza(string2, zza3);
            return;
        }
        catch (IOException iOException) {
            boolean bl = file.delete();
            if (!bl) {
                zzs.zzb("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    public synchronized void remove(String key) {
        boolean bl = this.zzf(key).delete();
        this.removeEntry(key);
        if (!bl) {
            zzs.zzb("Could not delete cache entry for key=%s, filename=%s", key, this.zze(key));
        }
    }

    private String zze(String string2) {
        int n = string2.length() / 2;
        String string3 = String.valueOf(string2.substring(0, n).hashCode());
        string3 = string3 + String.valueOf(string2.substring(n).hashCode());
        return string3;
    }

    public File zzf(String string2) {
        return new File(this.zzaz, this.zze(string2));
    }

    private void zzc(int n) {
        if (this.zzay + (long)n < (long)this.zzaA) {
            return;
        }
        if (zzs.DEBUG) {
            zzs.zza("Pruning old cache entries.", new Object[0]);
        }
        long l = this.zzay;
        int n2 = 0;
        long l2 = SystemClock.elapsedRealtime();
        Iterator<Map.Entry<String, zza>> iterator = this.zzax.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, zza> entry = iterator.next();
            zza zza2 = entry.getValue();
            boolean bl = this.zzf(zza2.key).delete();
            if (bl) {
                this.zzay -= zza2.zzaB;
            } else {
                zzs.zzb("Could not delete cache entry for key=%s, filename=%s", zza2.key, this.zze(zza2.key));
            }
            iterator.remove();
            ++n2;
            if (!((float)(this.zzay + (long)n) < (float)this.zzaA * 0.9f)) continue;
            break;
        }
        if (zzs.DEBUG) {
            zzs.zza("pruned %d files, %d bytes, %d ms", n2, this.zzay - l, SystemClock.elapsedRealtime() - l2);
        }
    }

    private void zza(String string2, zza zza2) {
        if (!this.zzax.containsKey(string2)) {
            this.zzay += zza2.zzaB;
        } else {
            zza zza3 = this.zzax.get(string2);
            this.zzay += zza2.zzaB - zza3.zzaB;
        }
        this.zzax.put(string2, zza2);
    }

    private void removeEntry(String key) {
        zza zza2 = this.zzax.get(key);
        if (zza2 != null) {
            this.zzay -= zza2.zzaB;
            this.zzax.remove(key);
        }
    }

    private static byte[] zza(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 != n) {
            throw new IOException("Expected " + n + " bytes, read " + n2 + " bytes");
        }
        return byArray;
    }

    private static int zza(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    static void zza(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 0 & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 24 & 0xFF);
    }

    static int zzb(InputStream inputStream) throws IOException {
        int n = 0;
        n |= zzv.zza(inputStream) << 0;
        n |= zzv.zza(inputStream) << 8;
        n |= zzv.zza(inputStream) << 16;
        return n |= zzv.zza(inputStream) << 24;
    }

    static void zza(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)(l >>> 0));
        outputStream.write((byte)(l >>> 8));
        outputStream.write((byte)(l >>> 16));
        outputStream.write((byte)(l >>> 24));
        outputStream.write((byte)(l >>> 32));
        outputStream.write((byte)(l >>> 40));
        outputStream.write((byte)(l >>> 48));
        outputStream.write((byte)(l >>> 56));
    }

    static long zzc(InputStream inputStream) throws IOException {
        long l = 0L;
        l |= ((long)zzv.zza(inputStream) & 0xFFL) << 0;
        l |= ((long)zzv.zza(inputStream) & 0xFFL) << 8;
        l |= ((long)zzv.zza(inputStream) & 0xFFL) << 16;
        l |= ((long)zzv.zza(inputStream) & 0xFFL) << 24;
        l |= ((long)zzv.zza(inputStream) & 0xFFL) << 32;
        l |= ((long)zzv.zza(inputStream) & 0xFFL) << 40;
        l |= ((long)zzv.zza(inputStream) & 0xFFL) << 48;
        return l |= ((long)zzv.zza(inputStream) & 0xFFL) << 56;
    }

    static void zza(OutputStream outputStream, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF-8");
        zzv.zza(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String zzd(InputStream inputStream) throws IOException {
        int n = (int)zzv.zzc(inputStream);
        byte[] byArray = zzv.zza(inputStream, n);
        return new String(byArray, "UTF-8");
    }

    static void zza(Map<String, String> map, OutputStream outputStream) throws IOException {
        if (map != null) {
            zzv.zza(outputStream, map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                zzv.zza(outputStream, entry.getKey());
                zzv.zza(outputStream, entry.getValue());
            }
        } else {
            zzv.zza(outputStream, 0);
        }
    }

    static Map<String, String> zze(InputStream inputStream) throws IOException {
        int n = zzv.zzb(inputStream);
        HashMap<String, String> hashMap = n == 0 ? Collections.emptyMap() : new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = zzv.zzd(inputStream).intern();
            String string3 = zzv.zzd(inputStream).intern();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private static class zzb
    extends FilterInputStream {
        private int zzaC = 0;

        private zzb(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                ++this.zzaC;
            }
            return n;
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            int n = super.read(buffer, offset, count);
            if (n != -1) {
                this.zzaC += n;
            }
            return n;
        }
    }

    static class zza {
        public long zzaB;
        public String key;
        public String zzb;
        public long zzc;
        public long zzd;
        public long zze;
        public long zzf;
        public Map<String, String> zzg;

        private zza() {
        }

        public zza(String string2, zzb.zza zza2) {
            this.key = string2;
            this.zzaB = zza2.data.length;
            this.zzb = zza2.zzb;
            this.zzc = zza2.zzc;
            this.zzd = zza2.zzd;
            this.zze = zza2.zze;
            this.zzf = zza2.zzf;
            this.zzg = zza2.zzg;
        }

        public static zza zzf(InputStream inputStream) throws IOException {
            zza zza2 = new zza();
            int n = zzv.zzb(inputStream);
            if (n != 538247942) {
                throw new IOException();
            }
            zza2.key = zzv.zzd(inputStream);
            zza2.zzb = zzv.zzd(inputStream);
            if (zza2.zzb.equals("")) {
                zza2.zzb = null;
            }
            zza2.zzc = zzv.zzc(inputStream);
            zza2.zzd = zzv.zzc(inputStream);
            zza2.zze = zzv.zzc(inputStream);
            zza2.zzf = zzv.zzc(inputStream);
            zza2.zzg = zzv.zze(inputStream);
            return zza2;
        }

        public zzb.zza zzb(byte[] byArray) {
            zzb.zza zza2 = new zzb.zza();
            zza2.data = byArray;
            zza2.zzb = this.zzb;
            zza2.zzc = this.zzc;
            zza2.zzd = this.zzd;
            zza2.zze = this.zze;
            zza2.zzf = this.zzf;
            zza2.zzg = this.zzg;
            return zza2;
        }

        public boolean zza(OutputStream outputStream) {
            try {
                zzv.zza(outputStream, 538247942);
                zzv.zza(outputStream, this.key);
                zzv.zza(outputStream, this.zzb == null ? "" : this.zzb);
                zzv.zza(outputStream, this.zzc);
                zzv.zza(outputStream, this.zzd);
                zzv.zza(outputStream, this.zze);
                zzv.zza(outputStream, this.zzf);
                zzv.zza(this.zzg, outputStream);
                outputStream.flush();
                return true;
            }
            catch (IOException iOException) {
                zzs.zzb("%s", iOException.toString());
                return false;
            }
        }
    }
}

