/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzip;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgk
public class zzaz
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzpc = new Object();
    private final WeakReference<zzhj> zzqQ;
    private WeakReference<ViewTreeObserver> zzqR;
    private final WeakReference<View> zzqS;
    private final zzax zzqT;
    private final Context zzqO;
    private final zzdv zzqU;
    private final zzdv.zzd zzqV;
    private boolean zzqW;
    private final WindowManager zzqX;
    private final PowerManager zzqY;
    private final KeyguardManager zzqZ;
    private zzba zzra;
    private boolean zzrb;
    private boolean zzpB = false;
    private boolean zzrc = false;
    private boolean zzrd;
    private boolean zzre;
    private BroadcastReceiver zzrf;
    private final HashSet<zzaw> zzrg = new HashSet();
    private zzib zzqE;
    private final zzdg zzrh = new zzdg(){

        @Override
        public void zza(zzip zzip2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            zzaz.this.zza((View)zzip2.getWebView(), map);
        }
    };
    private final zzdg zzri = new zzdg(){

        @Override
        public void zza(zzip zzip2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            zzb.zzaC("Received request to untrack: " + zzaz.this.zzqT.zzbX());
            zzaz.this.destroy();
        }
    };
    private final zzdg zzrj = new zzdg(){

        @Override
        public void zza(zzip zzip2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzaz.this.zzg(bl);
        }
    };

    public zzaz(AdSizeParcel adSizeParcel, zzhj zzhj2, VersionInfoParcel versionInfoParcel, View view, zzdv zzdv2) {
        this.zzqU = zzdv2;
        this.zzqQ = new WeakReference<zzhj>(zzhj2);
        this.zzqS = new WeakReference<View>(view);
        this.zzqR = new WeakReference<Object>(null);
        this.zzrd = true;
        this.zzqE = new zzib(200L);
        this.zzqT = new zzax(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzsG, zzhj2.zzGF, zzhj2.zzbY());
        this.zzqV = this.zzqU.zzdL();
        this.zzqX = (WindowManager)view.getContext().getSystemService("window");
        this.zzqY = (PowerManager)view.getContext().getApplicationContext().getSystemService("power");
        this.zzqZ = (KeyguardManager)view.getContext().getSystemService("keyguard");
        this.zzqO = view.getContext().getApplicationContext();
        try {
            final JSONObject jSONObject = this.zzd(view);
            this.zzqV.zza(new zzij.zzc<zzbe>(){

                public void zzb(zzbe zzbe2) {
                    zzaz.this.zza(jSONObject);
                }

                @Override
                public /* synthetic */ void zzc(Object object) {
                    this.zzb((zzbe)object);
                }
            }, new zzij.zza(){

                @Override
                public void run() {
                }
            });
        }
        catch (JSONException jSONException) {
        }
        catch (RuntimeException runtimeException) {
            zzb.zzb("Failure while processing active view data.", runtimeException);
        }
        this.zzqV.zza(new zzij.zzc<zzbe>(){

            public void zzb(zzbe zzbe2) {
                zzaz.this.zzqW = true;
                zzaz.this.zza(zzbe2);
                zzaz.this.zzbZ();
                zzaz.this.zzh(false);
            }

            @Override
            public /* synthetic */ void zzc(Object object) {
                this.zzb((zzbe)object);
            }
        }, new zzij.zza(){

            @Override
            public void run() {
                zzaz.this.destroy();
            }
        });
        zzb.zzaC("Tracking ad unit: " + this.zzqT.zzbX());
    }

    public void zza(zzaw zzaw2) {
        this.zzrg.add(zzaw2);
    }

    protected void zzg(boolean bl) {
        for (zzaw zzaw2 : this.zzrg) {
            zzaw2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbZ() {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzrf != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzrf = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzaz.this.zzh(false);
                }
            };
            this.zzqO.registerReceiver(this.zzrf, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzca() {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzrf != null) {
                this.zzqO.unregisterReceiver(this.zzrf);
                this.zzrf = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzcf();
            this.zzca();
            this.zzrd = false;
            this.zzcc();
            this.zzqV.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcb() {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzrd) {
                this.zzre = true;
                try {
                    JSONObject jSONObject = this.zzch();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzb.zzb("JSON failure while processing active view data.", jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzb.zzb("Failure while processing active view data.", runtimeException);
                }
                zzb.zzaC("Untracking ad unit: " + this.zzqT.zzbX());
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(boolean bl) {
        Object object = this.zzpc;
        synchronized (object) {
            boolean bl2;
            if (!this.zzqW || !this.zzrd) {
                return;
            }
            if (bl && !this.zzqE.tryAcquire()) {
                return;
            }
            zzhj zzhj2 = (zzhj)this.zzqQ.get();
            View view = (View)this.zzqS.get();
            boolean bl3 = bl2 = view == null || zzhj2 == null;
            if (bl2) {
                this.zzcb();
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                zzb.zza("Active view update failed.", throwable);
            }
            this.zzce();
            this.zzcc();
        }
    }

    protected void zzcc() {
        if (this.zzra != null) {
            this.zzra.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzcd() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzrd;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzce() {
        View view = (View)this.zzqS.get();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzqR.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzcf();
        if (!this.zzrb || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzrb = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzqR = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string) && string.equals(this.zzqT.zzbX());
    }

    protected void zza(zzbe zzbe2) {
        zzbe2.zza("/updateActiveView", this.zzrh);
        zzbe2.zza("/untrackActiveViewUnit", this.zzri);
        zzbe2.zza("/visibilityChanged", this.zzrj);
    }

    protected void zzcf() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzqR.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzcg() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzqT.zzbV()).put("activeViewJSON", (Object)this.zzqT.zzbW()).put("timestamp", zzp.zzbB().elapsedRealtime()).put("adFormat", (Object)this.zzqT.zzbU()).put("hashCode", (Object)this.zzqT.zzbX()).put("isMraid", this.zzqT.zzbY());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            final JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzqV.zza(new zzij.zzc<zzbe>(){

                public void zzb(zzbe zzbe2) {
                    zzbe2.zza("AFMA_updateActiveView", jSONObject2);
                }

                @Override
                public /* synthetic */ void zzc(Object object) {
                    this.zzb((zzbe)object);
                }
            }, new zzij.zzb());
        }
        catch (Throwable throwable) {
            zzb.zzb("Skipping active view message.", throwable);
        }
    }

    protected JSONObject zzd(View view) throws JSONException {
        boolean bl = zzp.zzbz().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzb.zzb("Failure getting view location.", exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzqX.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzqX.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzcg();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isStopped", this.zzrc).put("isPaused", this.zzpB).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", this.zze(view));
        return jSONObject;
    }

    protected boolean zze(View view) {
        return view.getVisibility() == 0 && view.isShown() && this.isScreenOn() && (!this.zzqZ.inKeyguardRestrictedInputMode() || zzp.zzbx().zzgq());
    }

    boolean isScreenOn() {
        return this.zzqY.isScreenOn();
    }

    protected JSONObject zzch() throws JSONException {
        JSONObject jSONObject = this.zzcg();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzh(true);
    }

    public void onGlobalLayout() {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzba zzba2) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzra = zzba2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzrc = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzpB = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzpB = false;
            this.zzh(false);
        }
    }
}

