/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.util.SparseArray;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.internal.zzf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    private int zzUC = 0;
    private long zzUD;
    private MediaInfo zzUm;
    private double zzUE;
    private int zzUF;
    private int zzUG;
    private long zzUH;
    private long zzUI;
    private double zzUJ;
    private boolean zzUK;
    private long[] zzUA;
    private JSONObject zzUl;
    private int zzUL = 0;
    private int zzUM = 0;
    private final zza zzUN = new zza();

    public MediaStatus(JSONObject json) throws JSONException {
        this.zza(json, 0);
    }

    public long zzmc() {
        return this.zzUD;
    }

    public int getPlayerState() {
        return this.zzUF;
    }

    public int getIdleReason() {
        return this.zzUG;
    }

    public double getPlaybackRate() {
        return this.zzUE;
    }

    public MediaInfo getMediaInfo() {
        return this.zzUm;
    }

    public long getStreamPosition() {
        return this.zzUH;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.zzUI & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.zzUJ;
    }

    public boolean isMute() {
        return this.zzUK;
    }

    public long[] getActiveTrackIds() {
        return this.zzUA;
    }

    public JSONObject getCustomData() {
        return this.zzUl;
    }

    public int getCurrentItemId() {
        return this.zzUC;
    }

    public int getLoadingItemId() {
        return this.zzUL;
    }

    public int getPreloadedItemId() {
        return this.zzUM;
    }

    public int getQueueRepeatMode() {
        return this.zzUN.getRepeatMode();
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzUN.zzmd();
    }

    public int getQueueItemCount() {
        return this.zzUN.getItemCount();
    }

    public MediaQueueItem getQueueItemById(int itemId) {
        return this.zzUN.zzaL(itemId);
    }

    public MediaQueueItem getQueueItem(int index) {
        return this.zzUN.zzaM(index);
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        long l;
        long l2;
        double d;
        int n5 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzUD) {
            this.zzUD = l3;
            n5 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n6 = 0;
            String string = jSONObject.getString("playerState");
            if (string.equals("IDLE")) {
                n6 = 1;
            } else if (string.equals("PLAYING")) {
                n6 = 2;
            } else if (string.equals("PAUSED")) {
                n6 = 3;
            } else if (string.equals("BUFFERING")) {
                n6 = 4;
            }
            if (n6 != this.zzUF) {
                this.zzUF = n6;
                n5 |= 2;
            }
            if (n6 == 1 && jSONObject.has("idleReason")) {
                int n7 = 0;
                string = jSONObject.getString("idleReason");
                if (string.equals("CANCELLED")) {
                    n7 = 2;
                } else if (string.equals("INTERRUPTED")) {
                    n7 = 3;
                } else if (string.equals("FINISHED")) {
                    n7 = 1;
                } else if (string.equals("ERROR")) {
                    n7 = 4;
                }
                if (n7 != this.zzUG) {
                    this.zzUG = n7;
                    n5 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzUE != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzUE = d;
            n5 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzf.zzf(jSONObject.getDouble("currentTime"))) != this.zzUH) {
            this.zzUH = l2;
            n5 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzUI) {
            this.zzUI = l;
            n5 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzUJ) {
                this.zzUJ = d2;
                n5 |= 2;
            }
            if ((n4 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzUK) {
                this.zzUK = n4;
                n5 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n8;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n4 = jSONArray.length();
            lArray = new long[n4];
            for (n8 = 0; n8 < n4; ++n8) {
                lArray[n8] = jSONArray.getLong(n8);
            }
            if (this.zzUA == null) {
                bl = true;
            } else if (this.zzUA.length != n4) {
                bl = true;
            } else {
                for (n8 = 0; n8 < n4; ++n8) {
                    if (this.zzUA[n8] == lArray[n8]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzUA = lArray;
            }
        } else if (this.zzUA != null) {
            bl = true;
        }
        if (bl) {
            this.zzUA = lArray;
            n5 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzUl = jSONObject.getJSONObject("customData");
            n5 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.zzUm = new MediaInfo(jSONObject3);
            n5 |= 2;
            if (jSONObject3.has("metadata")) {
                n5 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.zzUC != (n3 = jSONObject.getInt("currentItemId"))) {
            this.zzUC = n3;
            n5 |= 2;
        }
        if (this.zzUM != (n2 = jSONObject.optInt("preloadedItemId", 0))) {
            this.zzUM = n2;
            n5 |= 0x10;
        }
        if (this.zzUL != (n4 = jSONObject.optInt("loadingItemId", 0))) {
            this.zzUL = n4;
            n5 |= 2;
        }
        if (!this.zzi(this.zzUF, this.zzUL)) {
            if (this.zzUN.zzg(jSONObject)) {
                n5 |= 8;
            }
        } else {
            this.zzUC = 0;
            this.zzUL = 0;
            this.zzUM = 0;
            if (this.zzUN.getItemCount() > 0) {
                this.zzUN.clear();
                n5 |= 8;
            }
        }
        return n5;
    }

    private boolean zzi(int n, int n2) {
        return n == 1 && n2 == 0;
    }

    private class zza {
        private int zzUO = 0;
        private List<MediaQueueItem> zzUP = new ArrayList<MediaQueueItem>();
        private SparseArray<Integer> zzUQ = new SparseArray();

        zza() {
        }

        private boolean zzg(JSONObject jSONObject) throws JSONException {
            int n;
            String string;
            boolean bl = false;
            if (jSONObject.has("repeatMode")) {
                String string2;
                int n2 = this.zzUO;
                string = string2 = jSONObject.getString("repeatMode");
                n = -1;
                switch (string.hashCode()) {
                    case 1645952171: {
                        if (!string.equals("REPEAT_OFF")) break;
                        n = 0;
                        break;
                    }
                    case 1645938909: {
                        if (!string.equals("REPEAT_ALL")) break;
                        n = 1;
                        break;
                    }
                    case -962896020: {
                        if (!string.equals("REPEAT_SINGLE")) break;
                        n = 2;
                        break;
                    }
                    case -1118317585: {
                        if (!string.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                    }
                }
                if (this.zzUO != n2) {
                    this.zzUO = n2;
                    bl = true;
                }
            }
            if (jSONObject.has("items")) {
                JSONArray jSONArray = jSONObject.getJSONArray("items");
                int n3 = jSONArray.length();
                string = new SparseArray();
                for (n = 0; n < n3; ++n) {
                    string.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
                }
                MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
                for (int i = 0; i < n3; ++i) {
                    Integer n4 = (Integer)string.get(i);
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = this.zzaL(n4);
                    if (mediaQueueItem != null) {
                        bl |= mediaQueueItem.zzg(jSONObject2);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == this.zzaN(n4)) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                    if (n4 == MediaStatus.this.zzUC) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(MediaStatus.this.zzUm).build();
                        mediaQueueItemArray[i].zzg(jSONObject2);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
                }
                if (this.zzUP.size() != n3) {
                    bl = true;
                }
                this.zza(mediaQueueItemArray);
            }
            return bl;
        }

        public int getRepeatMode() {
            return this.zzUO;
        }

        public List<MediaQueueItem> zzmd() {
            return Collections.unmodifiableList(this.zzUP);
        }

        public int getItemCount() {
            return this.zzUP.size();
        }

        public MediaQueueItem zzaL(int n) {
            Integer n2 = (Integer)this.zzUQ.get(n);
            return n2 == null ? null : this.zzUP.get(n2);
        }

        public MediaQueueItem zzaM(int n) {
            if (n < 0 || n >= this.zzUP.size()) {
                return null;
            }
            return this.zzUP.get(n);
        }

        private Integer zzaN(int n) {
            return (Integer)this.zzUQ.get(n);
        }

        private void zza(MediaQueueItem[] mediaQueueItemArray) {
            this.zzUP.clear();
            this.zzUQ.clear();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
                this.zzUP.add(mediaQueueItem);
                this.zzUQ.put(mediaQueueItem.getItemId(), (Object)i);
            }
        }

        private void clear() {
            this.zzUO = 0;
            this.zzUP.clear();
            this.zzUQ.clear();
        }
    }
}

