/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzaYU;
    private final DataMap zzaYT;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzaYU = putDataRequest;
        this.zzaYT = new DataMap();
        if (dataMap != null) {
            this.zzaYT.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.zzo(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.zzaYU.getUri();
    }

    public DataMap getDataMap() {
        return this.zzaYT;
    }

    public PutDataRequest asPutDataRequest() {
        zzrl.zza zza2 = zzrl.zza(this.zzaYT);
        this.zzaYU.setData(zzrx.zzf((zzrx)zza2.zzbbp));
        int n = zza2.zzbbq.size();
        for (int i = 0; i < n; ++i) {
            String string = Integer.toString(i);
            Asset asset = zza2.zzbbq.get(i);
            if (string == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string + " " + asset));
            }
            this.zzaYU.putAsset(string, asset);
        }
        return this.zzaYU;
    }
}

