/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.view.Display;
import android.view.Surface;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkp;

public class zzkl
implements CastRemoteDisplayApi {
    private static final zzl zzTy = new zzl("CastRemoteDisplayApiImpl");
    private Api.zzc<zzkm> zzXW;
    private VirtualDisplay zzXX;
    private final zzkp zzXY = new zzkp.zza(){

        @Override
        public void zzaZ(int n) {
            zzTy.zzb("onRemoteDisplayEnded", new Object[0]);
            zzkl.this.zzmP();
        }
    };

    public zzkl(Api.zzc<zzkm> zzc2) {
        this.zzXW = zzc2;
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> startRemoteDisplay(GoogleApiClient apiClient, final String appId) {
        zzTy.zzb("startRemoteDisplay", new Object[0]);
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            protected void zza(zzkm zzkm2) throws RemoteException {
                zzkm2.zza(new zzb.zza(zzkm2), zzkl.this.zzXY, appId);
            }
        });
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> stopRemoteDisplay(GoogleApiClient apiClient) {
        zzTy.zzb("stopRemoteDisplay", new Object[0]);
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            protected void zza(zzkm zzkm2) throws RemoteException {
                zzkm2.zza(new zzb.zzb());
            }
        });
    }

    private void zzmP() {
        if (this.zzXX != null) {
            Display display = this.zzXX.getDisplay();
            if (display != null) {
                zzTy.zzb("releasing virtual display: " + this.zzXX.getDisplay().getDisplayId(), new Object[0]);
            }
            this.zzXX.release();
            this.zzXX = null;
        }
    }

    private abstract class com.google.android.gms.internal.zzkl$zzb
    extends zzc.zza<CastRemoteDisplay.CastRemoteDisplaySessionResult, zzkm> {
        public com.google.android.gms.internal.zzkl$zzb(GoogleApiClient googleApiClient) {
            super(zzkl.this.zzXW, googleApiClient);
        }

        protected CastRemoteDisplay.CastRemoteDisplaySessionResult zzv(Status status) {
            return new zzc(status);
        }

        protected /* synthetic */ Result zzb(Status status) {
            return this.zzv(status);
        }

        protected final class zzb
        extends com.google.android.gms.internal.zzkl$zza {
            protected zzb() {
            }

            @Override
            public void onDisconnected() throws RemoteException {
                zzTy.zzb("onDisconnected", new Object[0]);
                zzkl.this.zzmP();
                zzb.this.zza(new zzc(Status.zzaaD));
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzTy.zzb("onError: %d", statusCode);
                zzkl.this.zzmP();
                zzb.this.zza(new zzc(Status.zzaaF));
            }
        }

        protected final class zza
        extends com.google.android.gms.internal.zzkl$zza {
            private final zzkm zzYb;

            public zza(zzkm zzkm2) {
                this.zzYb = zzkm2;
            }

            private int zzj(int n, int n2) {
                return (n < n2 ? n : n2) * 320 / 1080;
            }

            @Override
            public void zza(int n, int n2, Surface surface) {
                zzTy.zzb("onConnected", new Object[0]);
                DisplayManager displayManager = (DisplayManager)this.zzYb.getContext().getSystemService("display");
                if (displayManager == null) {
                    zzTy.zzc("Unable to get the display manager", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzaaF));
                    return;
                }
                zzkl.this.zzmP();
                int n3 = this.zzj(n, n2);
                zzkl.this.zzXX = displayManager.createVirtualDisplay("private_display", n, n2, n3, surface, 2);
                if (zzkl.this.zzXX == null) {
                    zzTy.zzc("Unable to create virtual display", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzaaF));
                    return;
                }
                Display display = zzkl.this.zzXX.getDisplay();
                if (display == null) {
                    zzTy.zzc("Virtual display does not have a display", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzaaF));
                    return;
                }
                try {
                    this.zzYb.zza(this, zzkl.this.zzXX.getDisplay().getDisplayId());
                }
                catch (RemoteException | IllegalStateException throwable) {
                    zzTy.zzc("Unable to provision the route's new virtual Display", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzaaF));
                }
            }

            @Override
            public void zzmR() {
                zzTy.zzb("onConnectedWithDisplay", new Object[0]);
                Display display = zzkl.this.zzXX.getDisplay();
                if (display != null) {
                    zzb.this.zza(new zzc(display));
                } else {
                    zzTy.zzc("Virtual display no longer has a display", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzaaF));
                }
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzTy.zzb("onError: %d", statusCode);
                zzkl.this.zzmP();
                zzb.this.zza(new zzc(Status.zzaaF));
            }
        }
    }

    private abstract class zza
    extends zzkn.zza {
        private zza() {
        }

        @Override
        public void zza(int n, int n2, Surface surface) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onError(int statusCode) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onDisconnected() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzmR() throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class zzc
    implements CastRemoteDisplay.CastRemoteDisplaySessionResult {
        private final Status zzQA;
        private final Display zzTK;

        public zzc(Display display) {
            this.zzQA = Status.zzaaD;
            this.zzTK = display;
        }

        public zzc(Status status) {
            this.zzQA = status;
            this.zzTK = null;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public Display getPresentationDisplay() {
            return this.zzTK;
        }
    }
}

