/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzs;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class zzcl
implements Runnable {
    private final Context mContext;
    private final zzqw zzaRm;
    private final String zzaOS;
    private final String zzaRn;
    private zzbf<zzaf.zzj> zzaRo;
    private volatile zzs zzaRp;
    private volatile String zzaPp;
    private volatile String zzaRq;

    public zzcl(Context context, String string, zzs zzs2) {
        this(context, string, new zzqw(), zzs2);
    }

    zzcl(Context context, String string, zzqw zzqw2, zzs zzs2) {
        this.mContext = context;
        this.zzaRm = zzqw2;
        this.zzaOS = string;
        this.zzaRp = zzs2;
        this.zzaPp = this.zzaRn = "/r?id=" + string;
        this.zzaRq = null;
    }

    @Override
    public void run() {
        if (this.zzaRo == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.zzaRo.zzzL();
        this.zzAz();
    }

    private boolean zzAy() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.v("...no network connectivity");
            return false;
        }
        return true;
    }

    void zza(zzbf<zzaf.zzj> zzbf2) {
        this.zzaRo = zzbf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zzAz() {
        block12: {
            if (!this.zzAy()) {
                this.zzaRo.zza(zzbf.zza.zzaQC);
                return;
            }
            zzbg.v("Start loading resource from network ...");
            String string = this.zzAA();
            InputStream inputStream = null;
            try (zzqv zzqv2 = this.zzaRm.zzBW();){
                try {
                    inputStream = zzqv2.zzfs(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.zzaE("No data is retrieved from the given url: " + string + ". Make sure container_id: " + this.zzaOS + " is correct.");
                    this.zzaRo.zza(zzbf.zza.zzaQE);
                    zzqv2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when loading resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaRo.zza(zzbf.zza.zzaQD);
                    zzqv2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzqp.zzc(inputStream, byteArrayOutputStream);
                    zzaf.zzj zzj2 = zzaf.zzj.zzd(byteArrayOutputStream.toByteArray());
                    zzbg.v("Successfully loaded supplemented resource: " + (Object)((Object)zzj2));
                    if (zzj2.zziR == null && zzj2.zziQ.length == 0) {
                        zzbg.v("No change for container: " + this.zzaOS);
                    }
                    this.zzaRo.zzB(zzj2);
                    break block12;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaRo.zza(zzbf.zza.zzaQE);
                    zzqv2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.v("Load resource from network finished.");
    }

    String zzAA() {
        String string = this.zzaRp.zzzN() + this.zzaPp + "&v=a65833898";
        if (this.zzaRq != null && !this.zzaRq.trim().equals("")) {
            string = string + "&pv=" + this.zzaRq;
        }
        if (zzcb.zzAv().zzAw().equals((Object)zzcb.zza.zzaRe)) {
            string = string + "&gtm_debug=x";
        }
        return string;
    }

    void zzeB(String string) {
        if (string == null) {
            this.zzaPp = this.zzaRn;
        } else {
            zzbg.zzaC("Setting CTFE URL path: " + string);
            this.zzaPp = string;
        }
    }

    void zzeQ(String string) {
        zzbg.zzaC("Setting previous container version: " + string);
        this.zzaRq = string;
    }
}

