/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.AnalyticsReceiver;
import com.google.android.gms.analytics.AnalyticsService;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzag;
import com.google.android.gms.analytics.internal.zzah;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzi;
import com.google.android.gms.analytics.internal.zzj;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.analytics.internal.zzv;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzl
extends zzd {
    private boolean mStarted;
    private final zzj zzMn;
    private final zzah zzMo;
    private final zzag zzMp;
    private final zzi zzMq;
    private long zzMr;
    private final zzt zzMs;
    private final zzt zzMt;
    private final zzaj zzMu;
    private long zzMv;
    private boolean zzMw;

    protected zzl(zzf zzf2, zzg zzg2) {
        super(zzf2);
        zzx.zzv((Object)zzg2);
        this.zzMr = Long.MIN_VALUE;
        this.zzMp = zzg2.zzk(zzf2);
        this.zzMn = zzg2.zzm(zzf2);
        this.zzMo = zzg2.zzn(zzf2);
        this.zzMq = zzg2.zzo(zzf2);
        this.zzMu = new zzaj(this.zzid());
        this.zzMs = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zziO();
            }
        };
        this.zzMt = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zziP();
            }
        };
    }

    @Override
    protected void zzhB() {
        this.zzMn.zza();
        this.zzMo.zza();
        this.zzMq.zza();
    }

    void start() {
        this.zzio();
        zzx.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        if (!this.zzif().zzjk()) {
            this.zziM();
        }
        this.zzig().zzf(new Runnable(){

            @Override
            public void run() {
                zzl.this.zziN();
            }
        });
    }

    private void zziM() {
        boolean bl;
        zzf zzf2 = this.zzia();
        Context context = zzf2.getContext();
        boolean bl2 = AnalyticsReceiver.zzV(context);
        if (!bl2) {
            this.zzbb("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = AnalyticsService.zzW(context);
            if (!bl) {
                this.zzbc("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzV(context);
        if (!bl) {
            this.zzbb("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzW(context);
            if (!bl3) {
                this.zzbb("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzbf(String string) {
        int n = this.getContext().checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zziN() {
        this.zzio();
        this.zzii().zzky();
        if (!this.zzbf("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbc("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzjc();
        }
        if (!this.zzbf("android.permission.INTERNET")) {
            this.zzbc("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzjc();
        }
        if (AnalyticsService.zzW(this.getContext())) {
            this.zzaY("AnalyticsService registered in the app manifest and enabled");
        } else if (this.zzif().zzjk()) {
            this.zzbc("Device AnalyticsService not registered! Hits will not be delivered reliably.");
        } else {
            this.zzbb("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!(this.zzMw || this.zzif().zzjk() || this.zzMn.isEmpty())) {
            this.zziQ();
        }
        this.zziU();
    }

    private void zziO() {
        this.zzb(new zzw(){

            @Override
            public void zzc(Throwable throwable) {
                zzl.this.zziU();
            }
        });
    }

    void zzhZ() {
        this.zzic();
        this.zzMv = this.zzid().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzic();
        if (!this.zzif().zzjk()) {
            this.zziR();
        }
    }

    public void zzhX() {
        zzof.zzic();
        this.zzio();
        this.zzaY("Service disconnected");
    }

    public void zzI(boolean bl) {
        this.zziU();
    }

    private void zziP() {
        try {
            this.zzMn.zziG();
            this.zziU();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzMt.zzt(this.zzif().zzjM());
    }

    protected void zzc(zzh zzh2) {
        this.zzic();
        this.zzb("Sending first hit to property", zzh2.zzix());
        if (this.zzii().zzkz().zzv(this.zzif().zzjP())) {
            return;
        }
        String string = this.zzii().zzkC();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzol zzol2 = zzam.zza(this.zzie(), string);
        this.zzb("Found relevant installation campaign", zzol2);
        this.zza(zzh2, zzol2);
    }

    public void zzs(long l) {
        zzof.zzic();
        this.zzio();
        if (l < 0L) {
            l = 0L;
        }
        this.zzMr = l;
        this.zziU();
    }

    protected void zziQ() {
        if (this.zzMw) {
            return;
        }
        if (!this.zzif().zzjm()) {
            return;
        }
        if (this.zzMq.isConnected()) {
            return;
        }
        long l = this.zzif().zzjH();
        if (this.zzMu.zzv(l)) {
            this.zzMu.start();
            this.zzaY("Connecting to service");
            if (this.zzMq.connect()) {
                this.zzaY("Connected to service");
                this.zzMu.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzh zzh2, boolean bl) {
        zzx.zzv((Object)zzh2);
        this.zzio();
        this.zzic();
        long l = -1L;
        try {
            this.zzMn.beginTransaction();
            this.zzMn.zza(zzh2.zziw(), zzh2.getClientId());
            l = this.zzMn.zza(zzh2.zziw(), zzh2.getClientId(), zzh2.zzix());
            if (!bl) {
                zzh2.zzn(l);
            } else {
                zzh2.zzn(l + 1L);
            }
            this.zzMn.zzb(zzh2);
            this.zzMn.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            long l2 = -1L;
            return l2;
        }
        finally {
            try {
                this.zzMn.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzab zzab2) {
        zzx.zzv((Object)zzab2);
        zzof.zzic();
        this.zzio();
        if (this.zzMw) {
            this.zzaZ("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzab2);
        }
        zzab2 = this.zzf(zzab2);
        this.zziQ();
        if (this.zzMq.zzb(zzab2)) {
            this.zzaZ("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        if (this.zzif().zzjk()) {
            this.zzie().zza(zzab2, "Service unavailable on package side");
            return;
        }
        try {
            this.zzMn.zzc(zzab2);
            this.zziU();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzie().zza(zzab2, "deliver: failed to insert hit to database");
        }
    }

    public void zzhU() {
        zzof.zzic();
        this.zzio();
        if (!this.zzif().zzjk()) {
            this.zzaY("Delete all hits from local store");
            try {
                this.zzMn.zziE();
                this.zzMn.zziF();
                this.zziU();
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Failed to delete hits from store", (Object)sQLiteException);
            }
        }
        this.zziQ();
        if (this.zzMq.zziA()) {
            this.zzaY("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzab zzf(zzab zzab2) {
        if (!TextUtils.isEmpty((CharSequence)zzab2.zzko())) {
            return zzab2;
        }
        zzai.zza zza2 = this.zzii().zzkD();
        Pair<String, Long> pair = zza2.zzkG();
        if (pair == null) {
            return zzab2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        String string2 = l + ":" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>(zzab2.zzn());
        hashMap.put("_m", string2);
        return zzab.zza(this, zzab2, hashMap);
    }

    public void zziR() {
        zzof.zzic();
        this.zzio();
        this.zzib();
        if (!this.zzif().zzjm()) {
            this.zzbb("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzMq.isConnected()) {
            this.zzaY("Service not connected");
            return;
        }
        if (this.zzMn.isEmpty()) {
            return;
        }
        this.zzaY("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzab> list;
            try {
                list = this.zzMn.zzp(this.zzif().zzjv());
                if (list.isEmpty()) {
                    this.zziU();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zziY();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzab zzab2 = list.get(0);
                if (!this.zzMq.zzb(zzab2)) {
                    this.zziU();
                    return;
                }
                list.remove(zzab2);
                try {
                    this.zzMn.zzq(zzab2.zzkj());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zziY();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zziS() {
        boolean bl;
        zzof.zzic();
        this.zzio();
        this.zzaY("Dispatching a batch of local hits");
        boolean bl2 = !this.zzMq.isConnected() && !this.zzif().zzjk();
        boolean bl3 = bl = !this.zzMo.zzku();
        if (bl2 && bl) {
            this.zzaY("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zzif().zzjv(), this.zzif().zzjw());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzab> list;
                block38: {
                    this.zzMn.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzMn.zzp(l);
                        if (!list.isEmpty()) break block38;
                        this.zzaY("Store is empty, nothing to dispatch");
                        this.zziY();
                        boolean bl4 = false;
                        return bl4;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zziY();
                        boolean bl5 = false;
                        try {
                            this.zzMn.setTransactionSuccessful();
                            this.zzMn.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zziY();
                            return false;
                        }
                        return bl5;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzab)object).zzkj() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zziY();
                    boolean bl6 = false;
                    return bl6;
                }
                if (this.zzMq.isConnected() && !this.zzif().zzjk()) {
                    this.zzaY("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzMq.zzb((zzab)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzab)object2).zzkj());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzMn.zzq(((zzab)object2).zzkj());
                            arrayList.add(((zzab)object2).zzkj());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zziY();
                            boolean bl7 = false;
                            try {
                                this.zzMn.setTransactionSuccessful();
                                this.zzMn.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zziY();
                                return false;
                            }
                            return bl7;
                        }
                    }
                }
                if (this.zzMo.zzku()) {
                    object2 = this.zzMo.zzf(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    list.removeAll((Collection<?>)object2);
                    try {
                        this.zzMn.zzd((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zziY();
                        boolean bl8 = false;
                        try {
                            this.zzMn.setTransactionSuccessful();
                            this.zzMn.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zziY();
                            return false;
                        }
                        return bl8;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                boolean bl9 = false;
                return bl9;
            }
            finally {
                try {
                    this.zzMn.setTransactionSuccessful();
                    this.zzMn.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zziY();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzw zzw2) {
        this.zza(zzw2, this.zzMv);
    }

    public void zza(final zzw zzw2, final long l) {
        block8: {
            zzof.zzic();
            this.zzio();
            long l2 = -1L;
            long l3 = this.zzii().zzkA();
            if (l3 != 0L) {
                l2 = Math.abs(this.zzid().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            if (!this.zzif().zzjk()) {
                this.zziQ();
            }
            try {
                boolean bl = this.zziS();
                if (bl) {
                    this.zzig().zzf(new Runnable(){

                        @Override
                        public void run() {
                            zzl.this.zza(zzw2, l);
                        }
                    });
                } else {
                    this.zzii().zzkB();
                    this.zziU();
                    if (zzw2 != null) {
                        zzw2.zzc(null);
                    }
                    if (this.zzMv != l) {
                        this.zzMp.zzkt();
                    }
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zzii().zzkB();
                this.zziU();
                if (zzw2 == null) break block8;
                zzw2.zzc(throwable);
            }
        }
    }

    public void zziT() {
        zzof.zzic();
        this.zzio();
        this.zzaZ("Sync dispatching local hits");
        long l = this.zzMv;
        if (!this.zzif().zzjk()) {
            this.zziQ();
        }
        try {
            while (this.zziS()) {
            }
            this.zzii().zzkB();
            this.zziU();
            if (this.zzMv != l) {
                this.zzMp.zzkt();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zziU();
        }
    }

    public long zziH() {
        zzof.zzic();
        this.zzio();
        try {
            return this.zzMn.zziH();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zziU() {
        boolean bl;
        this.zzia().zzic();
        this.zzio();
        if (!this.zziV()) {
            this.zzMp.unregister();
            this.zziY();
            return;
        }
        if (this.zzMn.isEmpty()) {
            this.zzMp.unregister();
            this.zziY();
            return;
        }
        if (!zzy.zzNH.get().booleanValue()) {
            this.zzMp.zzkr();
            bl = this.zzMp.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zziX();
        } else {
            this.zziY();
            this.zziW();
        }
    }

    private boolean zziV() {
        if (this.zzMw) {
            return false;
        }
        if (this.zzif().zzjk() && !this.zzif().zzjl()) {
            return false;
        }
        return this.zzjb() > 0L;
    }

    private void zziW() {
        long l;
        long l2;
        long l3;
        zzv zzv2 = this.zzih();
        if (!zzv2.zzjU()) {
            return;
        }
        if (!zzv2.zzbr() && (l3 = this.zziH()) != 0L && (l2 = Math.abs((l = this.zzid().currentTimeMillis()) - l3)) <= this.zzif().zzju()) {
            long l4 = this.zzif().zzjt();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzv2.zzjV();
        }
    }

    private void zziX() {
        long l;
        long l2;
        this.zziW();
        long l3 = this.zzjb();
        long l4 = this.zzii().zzkA();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zzid().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zzif().zzjr(), l3)) : Math.min(this.zzif().zzjr(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.zzMs.zzbr()) {
            l = Math.max(1L, l5 + this.zzMs.zzjR());
            this.zzMs.zzu(l);
        } else {
            this.zzMs.zzt(l5);
        }
    }

    private void zziY() {
        this.zziZ();
        this.zzja();
    }

    private void zziZ() {
        if (this.zzMs.zzbr()) {
            this.zzaY("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzMs.cancel();
    }

    private void zzja() {
        zzv zzv2 = this.zzih();
        if (zzv2.zzbr()) {
            zzv2.cancel();
        }
    }

    public long zzjb() {
        if (this.zzMr != Long.MIN_VALUE) {
            return this.zzMr;
        }
        long l = this.zzif().zzjs();
        if (this.zzhA().zzke()) {
            l = (long)this.zzhA().zzkV() * 1000L;
        }
        return l;
    }

    public void zzbg(String string) {
        zzx.zzcs((String)string);
        this.zzic();
        this.zzib();
        zzol zzol2 = zzam.zza(this.zzie(), string);
        if (zzol2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzii().zzkC();
        if (string.equals(string2)) {
            this.zzbb("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzii().zzbk(string);
        if (this.zzii().zzkz().zzv(this.zzif().zzjP())) {
            this.zzd("Campaign received too late, ignoring", zzol2);
            return;
        }
        this.zzb("Received installation campaign", zzol2);
        List<zzh> list = this.zzMn.zzr(0L);
        for (zzh zzh2 : list) {
            this.zza(zzh2, zzol2);
        }
    }

    private void zza(zzh zzh2, zzol zzol2) {
        zzx.zzv((Object)zzh2);
        zzx.zzv((Object)zzol2);
        zza zza2 = new zza(this.zzia());
        zza2.zzaN(zzh2.zzix());
        zza2.enableAdvertisingIdCollection(zzh2.zziy());
        zzob zzob2 = zza2.zzhq();
        zzjb zzjb2 = zzob2.zze(zzjb.class);
        zzjb2.zzaS("data");
        zzjb2.zzH(true);
        zzob2.zzb(zzol2);
        zzja zzja2 = zzob2.zze(zzja.class);
        zzok zzok2 = zzob2.zze(zzok.class);
        for (Map.Entry<String, String> entry : zzh2.zzn().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzok2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzok2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzok2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzok2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzjb2.setUserId(string2);
                continue;
            }
            zzja2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzh2.zzix(), zzol2);
        zzob2.zzL(this.zzii().zzky());
        zzob2.zzxl();
    }

    public void zzjc() {
        this.zzio();
        this.zzic();
        this.zzMw = true;
        this.zzMq.disconnect();
        this.zziU();
    }
}

