/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.WeakReference;

class SnackbarManager {
    private static final int MSG_TIMEOUT = 0;
    private static final int SHORT_DURATION_MS = 1500;
    private static final int LONG_DURATION_MS = 2750;
    private static SnackbarManager sSnackbarManager;
    private final Object mLock = new Object();
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    SnackbarManager.this.handleTimeout((SnackbarRecord)message.obj);
                    return true;
                }
            }
            return false;
        }
    });
    private SnackbarRecord mCurrentSnackbar;
    private SnackbarRecord mNextSnackbar;

    static SnackbarManager getInstance() {
        if (sSnackbarManager == null) {
            sSnackbarManager = new SnackbarManager();
        }
        return sSnackbarManager;
    }

    private SnackbarManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(int duration, Callback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isCurrentSnackbar(callback)) {
                this.mCurrentSnackbar.duration = duration;
                this.mHandler.removeCallbacksAndMessages((Object)this.mCurrentSnackbar);
                this.scheduleTimeoutLocked(this.mCurrentSnackbar);
                return;
            }
            if (this.isNextSnackbar(callback)) {
                this.mNextSnackbar.duration = duration;
            } else {
                this.mNextSnackbar = new SnackbarRecord(duration, callback);
            }
            if (this.mCurrentSnackbar != null && this.cancelSnackbarLocked(this.mCurrentSnackbar, 4)) {
                return;
            }
            this.mCurrentSnackbar = null;
            this.showNextSnackbarLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss(Callback callback, int event) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isCurrentSnackbar(callback)) {
                this.cancelSnackbarLocked(this.mCurrentSnackbar, event);
            } else if (this.isNextSnackbar(callback)) {
                this.cancelSnackbarLocked(this.mNextSnackbar, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDismissed(Callback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isCurrentSnackbar(callback)) {
                this.mCurrentSnackbar = null;
                if (this.mNextSnackbar != null) {
                    this.showNextSnackbarLocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShown(Callback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isCurrentSnackbar(callback)) {
                this.scheduleTimeoutLocked(this.mCurrentSnackbar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimeout(Callback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isCurrentSnackbar(callback)) {
                this.mHandler.removeCallbacksAndMessages((Object)this.mCurrentSnackbar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreTimeout(Callback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isCurrentSnackbar(callback)) {
                this.scheduleTimeoutLocked(this.mCurrentSnackbar);
            }
        }
    }

    private void showNextSnackbarLocked() {
        if (this.mNextSnackbar != null) {
            this.mCurrentSnackbar = this.mNextSnackbar;
            this.mNextSnackbar = null;
            Callback callback = (Callback)this.mCurrentSnackbar.callback.get();
            if (callback != null) {
                callback.show();
            } else {
                this.mCurrentSnackbar = null;
            }
        }
    }

    private boolean cancelSnackbarLocked(SnackbarRecord record, int event) {
        Callback callback = (Callback)record.callback.get();
        if (callback != null) {
            callback.dismiss(event);
            return true;
        }
        return false;
    }

    private boolean isCurrentSnackbar(Callback callback) {
        return this.mCurrentSnackbar != null && this.mCurrentSnackbar.isSnackbar(callback);
    }

    private boolean isNextSnackbar(Callback callback) {
        return this.mNextSnackbar != null && this.mNextSnackbar.isSnackbar(callback);
    }

    private void scheduleTimeoutLocked(SnackbarRecord r) {
        if (r.duration == -2) {
            return;
        }
        int durationMs = 2750;
        if (r.duration > 0) {
            durationMs = r.duration;
        } else if (r.duration == -1) {
            durationMs = 1500;
        }
        this.mHandler.removeCallbacksAndMessages((Object)r);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)0, (Object)r), (long)durationMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(SnackbarRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentSnackbar == record || this.mNextSnackbar == record) {
                this.cancelSnackbarLocked(record, 2);
            }
        }
    }

    private static class SnackbarRecord {
        private final WeakReference<Callback> callback;
        private int duration;

        SnackbarRecord(int duration, Callback callback) {
            this.callback = new WeakReference<Callback>(callback);
            this.duration = duration;
        }

        boolean isSnackbar(Callback callback) {
            return callback != null && this.callback.get() == callback;
        }
    }

    static interface Callback {
        public void show();

        public void dismiss(int var1);
    }
}

