/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.preference.ListPreference;
import android.support.v7.preference.PreferenceDialogFragmentCompat;

public class ListPreferenceDialogFragmentCompat
extends PreferenceDialogFragmentCompat {
    private int mClickedDialogEntryIndex;

    public static ListPreferenceDialogFragmentCompat newInstance(String key) {
        ListPreferenceDialogFragmentCompat fragment = new ListPreferenceDialogFragmentCompat();
        Bundle b = new Bundle(1);
        b.putString("key", key);
        fragment.setArguments(b);
        return fragment;
    }

    private ListPreference getListPreference() {
        return (ListPreference)this.getPreference();
    }

    @Override
    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        super.onPrepareDialogBuilder(builder);
        ListPreference preference = this.getListPreference();
        if (preference.getEntries() == null || preference.getEntryValues() == null) {
            throw new IllegalStateException("ListPreference requires an entries array and an entryValues array.");
        }
        this.mClickedDialogEntryIndex = preference.findIndexOfValue(preference.getValue());
        builder.setSingleChoiceItems(preference.getEntries(), this.mClickedDialogEntryIndex, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ListPreferenceDialogFragmentCompat.this.mClickedDialogEntryIndex = which;
                ListPreferenceDialogFragmentCompat.this.onClick(dialog, -1);
                dialog.dismiss();
            }
        });
        builder.setPositiveButton(null, null);
    }

    @Override
    public void onDialogClosed(boolean positiveResult) {
        String value;
        ListPreference preference = this.getListPreference();
        if (positiveResult && this.mClickedDialogEntryIndex >= 0 && preference.getEntryValues() != null && preference.callChangeListener(value = preference.getEntryValues()[this.mClickedDialogEntryIndex].toString())) {
            preference.setValue(value);
        }
    }
}

