/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int mVersionCode;
    public final long zzMS;
    public final long zzann;
    public final Session zzanp;
    public final int zzaov;
    public final List<RawDataSet> zzany;
    public final int zzanz;
    public final boolean zzanA;
    public static final Parcelable.Creator<RawBucket> CREATOR = new zzm();

    public RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.zzanp = session;
        this.zzaov = activity;
        this.zzany = dataSets;
        this.zzanz = bucketType;
        this.zzanA = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.mVersionCode = 2;
        this.zzMS = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.zzann = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.zzanp = bucket.getSession();
        this.zzaov = bucket.zzru();
        this.zzanz = bucket.getBucketType();
        this.zzanA = bucket.zzrv();
        List<DataSet> list = bucket.getDataSets();
        this.zzany = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.zzany.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawBucket && this.zza((RawBucket)o);
    }

    private boolean zza(RawBucket rawBucket) {
        return this.zzMS == rawBucket.zzMS && this.zzann == rawBucket.zzann && this.zzaov == rawBucket.zzaov && zzw.equal(this.zzany, rawBucket.zzany) && this.zzanz == rawBucket.zzanz && this.zzanA == rawBucket.zzanA;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzMS, this.zzann, this.zzanz});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("startTime", (Object)this.zzMS).zzg("endTime", (Object)this.zzann).zzg("activity", (Object)this.zzaov).zzg("dataSets", this.zzany).zzg("bucketType", (Object)this.zzanz).zzg("serverHasMoreData", (Object)this.zzanA).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }
}

