/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntityCreator;
import com.google.android.gms.games.appcontent.AppContentCondition;
import com.google.android.gms.games.appcontent.AppContentConditionEntity;
import java.util.ArrayList;
import java.util.List;

public final class AppContentCardEntity
implements SafeParcelable,
AppContentCard {
    public static final AppContentCardEntityCreator CREATOR = new AppContentCardEntityCreator();
    private final int mVersionCode;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentAnnotationEntity> zzaso;
    private final ArrayList<AppContentConditionEntity> zzase;
    private final String zzasf;
    private final int zzasp;
    private final String zzaoB;
    private final Bundle mExtras;
    private final String zzasq;
    private final String zzagU;
    private final int zzasr;
    private final String zzFz;
    private final String zzwj;

    public AppContentCardEntity(AppContentCard card) {
        this.mVersionCode = 4;
        this.zzasf = card.zztb();
        this.zzasp = card.zztm();
        this.zzaoB = card.getDescription();
        this.mExtras = card.getExtras();
        this.zzwj = card.getId();
        this.zzagU = card.getTitle();
        this.zzasq = card.zztn();
        this.zzasr = card.zzto();
        this.zzFz = card.getType();
        List<AppContentAction> list = card.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentAnnotation> list2 = card.zztl();
        int n2 = list2.size();
        this.zzaso = new ArrayList(n2);
        for (int i = 0; i < n2; ++i) {
            this.zzaso.add((AppContentAnnotationEntity)list2.get(i).freeze());
        }
        List<AppContentCondition> list3 = card.zzta();
        int n3 = list3.size();
        this.zzase = new ArrayList(n3);
        for (int i = 0; i < n3; ++i) {
            this.zzase.add((AppContentConditionEntity)list3.get(i).freeze());
        }
    }

    AppContentCardEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentAnnotationEntity> annotations, ArrayList<AppContentConditionEntity> conditions, String contentDescription, int currentProgress, String description, Bundle extras, String subtitle, String title, int totalProgress, String type, String id) {
        this.mVersionCode = versionCode;
        this.mActions = actions;
        this.zzaso = annotations;
        this.zzase = conditions;
        this.zzasf = contentDescription;
        this.zzasp = currentProgress;
        this.zzaoB = description;
        this.mExtras = extras;
        this.zzwj = id;
        this.zzasq = subtitle;
        this.zzagU = title;
        this.zzasr = totalProgress;
        this.zzFz = type;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zztl() {
        return new ArrayList<AppContentAnnotation>(this.zzaso);
    }

    @Override
    public List<AppContentCondition> zzta() {
        return new ArrayList<AppContentCondition>(this.zzase);
    }

    @Override
    public String zztb() {
        return this.zzasf;
    }

    @Override
    public int zztm() {
        return this.zzasp;
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String getId() {
        return this.zzwj;
    }

    @Override
    public String zztn() {
        return this.zzasq;
    }

    @Override
    public String getTitle() {
        return this.zzagU;
    }

    @Override
    public int zzto() {
        return this.zzasr;
    }

    @Override
    public String getType() {
        return this.zzFz;
    }

    public AppContentCard zztp() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentCardEntity.zza(this);
    }

    static int zza(AppContentCard appContentCard) {
        return zzw.hashCode((Object[])new Object[]{appContentCard.getActions(), appContentCard.zztl(), appContentCard.zzta(), appContentCard.zztb(), appContentCard.zztm(), appContentCard.getDescription(), appContentCard.getExtras(), appContentCard.getId(), appContentCard.zztn(), appContentCard.getTitle(), appContentCard.zzto(), appContentCard.getType()});
    }

    public boolean equals(Object obj) {
        return AppContentCardEntity.zza(this, obj);
    }

    static boolean zza(AppContentCard appContentCard, Object object) {
        if (!(object instanceof AppContentCard)) {
            return false;
        }
        if (appContentCard == object) {
            return true;
        }
        AppContentCard appContentCard2 = (AppContentCard)object;
        return zzw.equal(appContentCard2.getActions(), appContentCard.getActions()) && zzw.equal(appContentCard2.zztl(), appContentCard.zztl()) && zzw.equal(appContentCard2.zzta(), appContentCard.zzta()) && zzw.equal((Object)appContentCard2.zztb(), (Object)appContentCard.zztb()) && zzw.equal((Object)appContentCard2.zztm(), (Object)appContentCard.zztm()) && zzw.equal((Object)appContentCard2.getDescription(), (Object)appContentCard.getDescription()) && zzw.equal((Object)appContentCard2.getExtras(), (Object)appContentCard.getExtras()) && zzw.equal((Object)appContentCard2.getId(), (Object)appContentCard.getId()) && zzw.equal((Object)appContentCard2.zztn(), (Object)appContentCard.zztn()) && zzw.equal((Object)appContentCard2.getTitle(), (Object)appContentCard.getTitle()) && zzw.equal((Object)appContentCard2.zzto(), (Object)appContentCard.zzto()) && zzw.equal((Object)appContentCard2.getType(), (Object)appContentCard.getType());
    }

    public String toString() {
        return AppContentCardEntity.zzb(this);
    }

    static String zzb(AppContentCard appContentCard) {
        return zzw.zzu((Object)appContentCard).zzg("Actions", appContentCard.getActions()).zzg("Annotations", appContentCard.zztl()).zzg("Conditions", appContentCard.zzta()).zzg("ContentDescription", (Object)appContentCard.zztb()).zzg("CurrentSteps", (Object)appContentCard.zztm()).zzg("Description", (Object)appContentCard.getDescription()).zzg("Extras", (Object)appContentCard.getExtras()).zzg("Id", (Object)appContentCard.getId()).zzg("Subtitle", (Object)appContentCard.zztn()).zzg("Title", (Object)appContentCard.getTitle()).zzg("TotalSteps", (Object)appContentCard.zzto()).zzg("Type", (Object)appContentCard.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentCardEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zztp();
    }
}

