/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.support.v7.media.MediaRouteProvider;
import android.support.v7.media.RegisteredMediaRouteProvider;
import java.util.ArrayList;
import java.util.Collections;

final class RegisteredMediaRouteProviderWatcher {
    private final Context mContext;
    private final Callback mCallback;
    private final Handler mHandler;
    private final PackageManager mPackageManager;
    private final ArrayList<RegisteredMediaRouteProvider> mProviders = new ArrayList();
    private boolean mRunning;
    private final BroadcastReceiver mScanPackagesReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            RegisteredMediaRouteProviderWatcher.this.scanPackages();
        }
    };
    private final Runnable mScanPackagesRunnable = new Runnable(){

        @Override
        public void run() {
            RegisteredMediaRouteProviderWatcher.this.scanPackages();
        }
    };

    public RegisteredMediaRouteProviderWatcher(Context context, Callback callback) {
        this.mContext = context;
        this.mCallback = callback;
        this.mHandler = new Handler();
        this.mPackageManager = context.getPackageManager();
    }

    public void start() {
        if (!this.mRunning) {
            this.mRunning = true;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.PACKAGE_ADDED");
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_CHANGED");
            filter.addAction("android.intent.action.PACKAGE_REPLACED");
            filter.addAction("android.intent.action.PACKAGE_RESTARTED");
            filter.addDataScheme("package");
            this.mContext.registerReceiver(this.mScanPackagesReceiver, filter, null, this.mHandler);
            this.mHandler.post(this.mScanPackagesRunnable);
        }
    }

    public void stop() {
        if (this.mRunning) {
            this.mRunning = false;
            this.mContext.unregisterReceiver(this.mScanPackagesReceiver);
            this.mHandler.removeCallbacks(this.mScanPackagesRunnable);
            for (int i = this.mProviders.size() - 1; i >= 0; --i) {
                this.mProviders.get(i).stop();
            }
        }
    }

    private void scanPackages() {
        if (!this.mRunning) {
            return;
        }
        int targetIndex = 0;
        Intent intent = new Intent("android.media.MediaRouteProviderService");
        for (ResolveInfo resolveInfo : this.mPackageManager.queryIntentServices(intent, 0)) {
            RegisteredMediaRouteProvider provider;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null) continue;
            int sourceIndex = this.findProvider(serviceInfo.packageName, serviceInfo.name);
            if (sourceIndex < 0) {
                provider = new RegisteredMediaRouteProvider(this.mContext, new ComponentName(serviceInfo.packageName, serviceInfo.name));
                provider.start();
                this.mProviders.add(targetIndex++, provider);
                this.mCallback.addProvider(provider);
                continue;
            }
            if (sourceIndex < targetIndex) continue;
            provider = this.mProviders.get(sourceIndex);
            provider.start();
            provider.rebindIfDisconnected();
            Collections.swap(this.mProviders, sourceIndex, targetIndex++);
        }
        if (targetIndex < this.mProviders.size()) {
            for (int i = this.mProviders.size() - 1; i >= targetIndex; --i) {
                RegisteredMediaRouteProvider provider = this.mProviders.get(i);
                this.mCallback.removeProvider(provider);
                this.mProviders.remove(provider);
                provider.stop();
            }
        }
    }

    private int findProvider(String packageName, String className) {
        int count = this.mProviders.size();
        for (int i = 0; i < count; ++i) {
            RegisteredMediaRouteProvider provider = this.mProviders.get(i);
            if (!provider.hasComponentName(packageName, className)) continue;
            return i;
        }
        return -1;
    }

    public static interface Callback {
        public void addProvider(MediaRouteProvider var1);

        public void removeProvider(MediaRouteProvider var1);
    }
}

