/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzr;

public class Subscription
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzanm;
    private final DataType zzanl;
    private final long zzaoE;
    private final int zzaoF;
    public static final Parcelable.Creator<Subscription> CREATOR = new zzr();

    Subscription(int versionCode, DataSource dataSource, DataType dataType, long samplingIntervalMicros, int accuracyMode) {
        this.mVersionCode = versionCode;
        this.zzanm = dataSource;
        this.zzanl = dataType;
        this.zzaoE = samplingIntervalMicros;
        this.zzaoF = accuracyMode;
    }

    private Subscription(zza builder) {
        this.mVersionCode = 1;
        this.zzanl = builder.zzanl;
        this.zzanm = builder.zzanm;
        this.zzaoE = builder.zzaoE;
        this.zzaoF = builder.zzaoF;
    }

    public DataSource getDataSource() {
        return this.zzanm;
    }

    public DataType getDataType() {
        return this.zzanl;
    }

    public int getAccuracyMode() {
        return this.zzaoF;
    }

    public long zzrP() {
        return this.zzaoE;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Subscription && this.zza((Subscription)that);
    }

    private boolean zza(Subscription subscription) {
        return zzw.equal((Object)this.zzanm, (Object)subscription.zzanm) && zzw.equal((Object)this.zzanl, (Object)subscription.zzanl) && this.zzaoE == subscription.zzaoE && this.zzaoF == subscription.zzaoF;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanm, this.zzanm, this.zzaoE, this.zzaoF});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("dataSource", (Object)this.zzanm).zzg("dataType", (Object)this.zzanl).zzg("samplingIntervalMicros", (Object)this.zzaoE).zzg("accuracyMode", (Object)this.zzaoF).toString();
    }

    public String toDebugString() {
        return String.format("Subscription{%s}", this.zzanm == null ? this.zzanl.getName() : this.zzanm.toDebugString());
    }

    public DataType zzrQ() {
        return this.zzanl == null ? this.zzanm.getDataType() : this.zzanl;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzr.zza(this, dest, flags);
    }

    public static class zza {
        private DataSource zzanm;
        private DataType zzanl;
        private long zzaoE = -1L;
        private int zzaoF = 2;

        public zza zzb(DataSource dataSource) {
            this.zzanm = dataSource;
            return this;
        }

        public zza zzb(DataType dataType) {
            this.zzanl = dataType;
            return this;
        }

        public Subscription zzrR() {
            zzx.zza((this.zzanm != null || this.zzanl != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzanl == null || this.zzanm == null || this.zzanl.equals(this.zzanm.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new Subscription(this);
        }
    }
}

