/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zzln;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String zzasD;
    private final String mName;
    private final String zzaoB;
    private final Uri zzaqW;
    private final String zzarh;
    private final PlayerEntity zzarZ;
    private final long zzasE;
    private final String zzasF;
    private final boolean zzasG;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.zzasD = event.getEventId();
        this.mName = event.getName();
        this.zzaoB = event.getDescription();
        this.zzaqW = event.getIconImageUri();
        this.zzarh = event.getIconImageUrl();
        this.zzarZ = (PlayerEntity)event.getPlayer().freeze();
        this.zzasE = event.getValue();
        this.zzasF = event.getFormattedValue();
        this.zzasG = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.mVersionCode = versionCode;
        this.zzasD = eventId;
        this.mName = name;
        this.zzaoB = description;
        this.zzaqW = iconImageUri;
        this.zzarh = iconImageUrl;
        this.zzarZ = new PlayerEntity(player);
        this.zzasE = value;
        this.zzasF = formattedValue;
        this.zzasG = isVisible;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzasD;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaoB, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaqW;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzarh;
    }

    @Override
    public Player getPlayer() {
        return this.zzarZ;
    }

    @Override
    public long getValue() {
        return this.zzasE;
    }

    @Override
    public String getFormattedValue() {
        return this.zzasF;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzasF, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzasG;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzw.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzw.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzw.equal((Object)event2.getName(), (Object)event.getName()) && zzw.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzw.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzw.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzw.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzw.equal((Object)event2.getValue(), (Object)event.getValue()) && zzw.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzw.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzw.zzu((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

