/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaxY;
    private final PlayerEntity zzaza;
    private final byte[] zzayG;
    private final String zzBm;
    private final ArrayList<PlayerEntity> zzazb;
    private final int zzUS;
    private final long zzaxZ;
    private final long zzazc;
    private final Bundle zzazd;
    private final int zzxJ;

    public GameRequestEntity(GameRequest request) {
        this.mVersionCode = 2;
        this.zzaxY = new GameEntity(request.getGame());
        this.zzaza = new PlayerEntity(request.getSender());
        this.zzBm = request.getRequestId();
        this.zzUS = request.getType();
        this.zzaxZ = request.getCreationTimestamp();
        this.zzazc = request.getExpirationTimestamp();
        this.zzxJ = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.zzayG = null;
        } else {
            this.zzayG = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzayG, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n = list.size();
        this.zzazb = new ArrayList(n);
        this.zzazd = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzazb.add((PlayerEntity)player);
            this.zzazd.putInt(string, request.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.mVersionCode = versionCode;
        this.zzaxY = game;
        this.zzaza = sender;
        this.zzayG = data;
        this.zzBm = requestId;
        this.zzazb = recipients;
        this.zzUS = type;
        this.zzaxZ = creationTimestamp;
        this.zzazc = expirationTimestamp;
        this.zzazd = recipientStatuses;
        this.zzxJ = status;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzBm;
    }

    @Override
    public Game getGame() {
        return this.zzaxY;
    }

    @Override
    public Player getSender() {
        return this.zzaza;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzazb);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzayG;
    }

    @Override
    public int getType() {
        return this.zzUS;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaxZ;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzazc;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.zzazd.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.zzxJ;
    }

    public Bundle zzvb() {
        return this.zzazd;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzw.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzw.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzw.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzw.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzw.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzw.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzw.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzw.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzw.zzu((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.zza(this, dest, flags);
    }
}

