/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class OneoffTask
extends Task {
    private final long zzaAb;
    private final long zzaAc;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new Parcelable.Creator<OneoffTask>(){

        public OneoffTask zzeh(Parcel parcel) {
            return new OneoffTask(parcel);
        }

        public OneoffTask[] zzgt(int n) {
            return new OneoffTask[n];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.zzgt(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzeh(x0);
        }
    };

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzaAb = builder.zzaAd;
        this.zzaAc = builder.zzaAe;
    }

    @Deprecated
    private OneoffTask(Parcel in) {
        super(in);
        this.zzaAb = in.readLong();
        this.zzaAc = in.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzaAb);
        bundle.putLong("window_end", this.zzaAc);
    }

    public long getWindowStart() {
        return this.zzaAb;
    }

    public long getWindowEnd() {
        return this.zzaAc;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeLong(this.zzaAb);
        parcel.writeLong(this.zzaAc);
    }

    public String toString() {
        return super.toString() + " " + "windowStart=" + this.getWindowStart() + " " + "windowEnd=" + this.getWindowEnd();
    }

    public static class Builder
    extends Task.Builder {
        private long zzaAd = -1L;
        private long zzaAe = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long windowStartDelaySeconds, long windowEndDelaySeconds) {
            this.zzaAd = windowStartDelaySeconds;
            this.zzaAe = windowEndDelaySeconds;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> gcmTaskService) {
            this.gcmTaskService = gcmTaskService.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int requiredNetworkState) {
            this.requiredNetworkState = requiredNetworkState;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return this;
        }

        @Override
        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Builder setPersisted(boolean isPersisted) {
            this.isPersisted = isPersisted;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.updateCurrent = updateCurrent;
            return this;
        }

        @Override
        public Builder setExtras(Bundle extras) {
            this.extras = extras;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaAd == -1L || this.zzaAe == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzaAd >= this.zzaAe) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this);
        }
    }
}

