/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.internal.DeleteResourceRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.TrashResourceRequest;
import com.google.android.gms.drive.internal.UntrashResourceRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzo;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import java.util.ArrayList;
import java.util.Set;

public class zzaa
implements DriveResource {
    protected final DriveId zzags;

    protected zzaa(DriveId driveId) {
        this.zzags = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzags;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient apiClient) {
        return this.zza(apiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza((zzc.zza)new zzd(googleApiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new GetMetadataRequest(zzaa.this.zzags, bl), (zzam)new zzb((zzc.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient apiClient) {
        return apiClient.zza((zzc.zza)new zzr.zzg(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new ListParentsRequest(zzaa.this.zzags), (zzam)new zza((zzc.zzb<DriveApi.MetadataBufferResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient apiClient, Set<DriveId> parentIds) {
        if (parentIds == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(parentIds);
        return apiClient.zzb((zzc.zza)new zzs.zza(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new SetResourceParentsRequest(zzaa.this.zzags, arrayList), (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return apiClient.zzb((zzc.zza)new zzd(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                changeSet.zzqp().setContext(zzt2.getContext());
                zzt2.zzqF().zza(new UpdateMetadataRequest(zzaa.this.zzags, changeSet.zzqp()), (zzam)new zzb((zzc.zzb<DriveResource.MetadataResult>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient apiClient) {
        return apiClient.zzb((zzc.zza)new zzs.zza(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new DeleteResourceRequest(zzaa.this.zzags), (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzt zzt2 = (zzt)apiClient.zza(Drive.zzQf);
        return zzt2.zza(apiClient, this.zzags, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzt zzt2 = (zzt)apiClient.zza(Drive.zzQf);
        return zzt2.zzb(apiClient, this.zzags, listener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient apiClient) {
        zzt zzt2 = (zzt)apiClient.zza(Drive.zzQf);
        return zzt2.zza(apiClient, this.zzags);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient apiClient) {
        zzt zzt2 = (zzt)apiClient.zza(Drive.zzQf);
        return zzt2.zzb(apiClient, this.zzags);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient apiClient) {
        return apiClient.zzb((zzc.zza)new zzs.zza(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new TrashResourceRequest(zzaa.this.zzags), (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient apiClient) {
        return apiClient.zzb((zzc.zza)new zzs.zza(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new UntrashResourceRequest(zzaa.this.zzags), (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zzc.zzb<DriveApi.MetadataBufferResult> zzQz;

        public zza(zzc.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzQz = zzb2;
        }

        @Override
        public void zza(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.zzqV());
            this.zzQz.zzn((Object)new zzr.zzf(Status.zzaaD, metadataBuffer, false));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzQz.zzn((Object)new zzr.zzf(status, null, false));
        }
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zzc.zzb<DriveResource.MetadataResult> zzQz;

        public zzb(zzc.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzQz = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzQz.zzn((Object)new zzc(Status.zzaaD, new zzo(onMetadataResponse.zzqW())));
        }

        @Override
        public void zzy(Status status) throws RemoteException {
            this.zzQz.zzn((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzQA;
        private final Metadata zzajd;

        public zzc(Status status, Metadata metadata) {
            this.zzQA = status;
            this.zzajd = metadata;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzajd;
        }
    }

    private abstract class zzd
    extends zzs<DriveResource.MetadataResult> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzG(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzG(status);
        }
    }
}

