/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.tagmanager.zzbg;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class zzqy
implements Runnable {
    private final Context mContext;
    private final zzqx zzaUv;
    private final zzqw zzaRm;
    private final zzqn zzaUo;
    private final zzqs zzaUw;

    public zzqy(Context context, zzqn zzqn2, zzqx zzqx2) {
        this(context, zzqn2, zzqx2, new zzqw(), new zzqs());
    }

    public zzqy(Context context, zzqn zzqn2, zzqx zzqx2, String string) {
        this(context, zzqn2, zzqx2, new zzqw(), new zzqs());
        this.zzaUw.zzfj(string);
    }

    zzqy(Context context, zzqn zzqn2, zzqx zzqx2, zzqw zzqw2, zzqs zzqs2) {
        zzx.zzv((Object)context);
        zzx.zzv((Object)zzqx2);
        this.mContext = context;
        this.zzaUo = zzqn2;
        this.zzaUv = zzqx2;
        this.zzaRm = zzqw2;
        this.zzaUw = zzqs2;
    }

    @Override
    public void run() {
        this.zzeP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void zzeP() {
        block11: {
            if (!this.zzBY()) {
                this.zzaUv.zza(zzqx.zza.zzaUq);
                return;
            }
            zzbg.v("NetworkLoader: Starting to load resource from Network.");
            InputStream inputStream = null;
            try (zzqv zzqv2 = this.zzaRm.zzBW();){
                String string = this.zzaUw.zzt(this.zzaUo.zzBv());
                try {
                    inputStream = zzqv2.zzfs(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.e("NetworkLoader: No data is retrieved from the given url: " + string);
                    this.zzaUv.zza(zzqx.zza.zzaUs);
                    zzqv2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzb("NetworkLoader: Error when loading resource from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaUv.zza(zzqx.zza.zzaUr);
                    zzqv2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzlr.zza((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                    this.zzaUv.zzu(byteArrayOutputStream.toByteArray());
                    break block11;
                }
                catch (IOException iOException) {
                    zzbg.zzb("NetworkLoader: Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaUv.zza(zzqx.zza.zzaUs);
                    zzqv2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.v("NetworkLoader: Resource loaded.");
    }

    boolean zzBY() {
        if (!this.zzbf("android.permission.INTERNET")) {
            zzbg.e("Missing android.permission.INTERNET. Please add the following declaration to your AndroidManifest.xml: <uses-permission android:name=\"android.permission.INTERNET\" />");
            return false;
        }
        if (!this.zzbf("android.permission.ACCESS_NETWORK_STATE")) {
            zzbg.e("Missing android.permission.ACCESS_NETWORK_STATE. Please add the following declaration to your AndroidManifest.xml: <uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />");
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.zzaE("NetworkLoader: No network connectivity - Offline");
            return false;
        }
        return true;
    }

    boolean zzbf(String string) {
        return this.mContext.getPackageManager().checkPermission(string, this.mContext.getPackageName()) == 0;
    }
}

