/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzKp;
    private final Tracker zzKq;
    private final Context mContext;
    private ExceptionParser zzKr;
    private GoogleAnalytics zzKs;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzKp = originalHandler;
        this.zzKq = tracker;
        this.zzKr = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        zzae.v("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzKr;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzKr = exceptionParser;
    }

    GoogleAnalytics zzhu() {
        if (this.zzKs == null) {
            this.zzKs = GoogleAnalytics.getInstance(this.mContext);
        }
        return this.zzKs;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Object object;
        String string = "UncaughtException";
        if (this.zzKr != null) {
            object = t != null ? t.getName() : null;
            string = this.zzKr.getDescription((String)object, e);
        }
        zzae.v("Reporting uncaught exception: " + string);
        this.zzKq.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        object = this.zzhu();
        ((GoogleAnalytics)object).dispatchLocalHits();
        ((GoogleAnalytics)object).zzhy();
        if (this.zzKp != null) {
            zzae.v("Passing exception to the original handler");
            this.zzKp.uncaughtException(t, e);
        }
    }

    Thread.UncaughtExceptionHandler zzhv() {
        return this.zzKp;
    }
}

