/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.tagmanager.zzac;
import com.google.android.gms.tagmanager.zzal;
import com.google.android.gms.tagmanager.zzaq;
import com.google.android.gms.tagmanager.zzau;
import com.google.android.gms.tagmanager.zzav;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcu;
import com.google.android.gms.tagmanager.zzcx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class zzby
implements zzau {
    private static final String zzMg = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL,'%s' INTEGER NOT NULL);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time");
    private final zzb zzaQM;
    private volatile zzac zzaQN;
    private final zzav zzaQO;
    private final Context mContext;
    private final String zzaQP;
    private long zzaQQ;
    private zzlm zzpO;
    private final int zzaQR;

    zzby(zzav zzav2, Context context) {
        this(zzav2, context, "gtm_urls.db", 2000);
    }

    zzby(zzav zzav2, Context context, String string, int n) {
        this.mContext = context.getApplicationContext();
        this.zzaQP = string;
        this.zzaQO = zzav2;
        this.zzpO = zzlo.zzpN();
        this.zzaQM = new zzb(this.mContext, this.zzaQP);
        this.zzaQN = new zzcx((HttpClient)new DefaultHttpClient(), this.mContext, new zza());
        this.zzaQQ = 0L;
        this.zzaQR = n;
    }

    @Override
    public void zzg(long l, String string) {
        this.zziG();
        this.zzAr();
        this.zzh(l, string);
    }

    private void zzAr() {
        int n = this.zzAs() - this.zzaQR + 1;
        if (n > 0) {
            List<String> list = this.zzjj(n);
            zzbg.v("Store full, deleting " + list.size() + " hits to make room.");
            this.zzf(list.toArray(new String[0]));
        }
    }

    private void zzh(long l, String string) {
        SQLiteDatabase sQLiteDatabase = this.zzeG("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_time", Long.valueOf(l));
        contentValues.put("hit_url", string);
        contentValues.put("hit_first_send_time", Integer.valueOf(0));
        try {
            sQLiteDatabase.insert("gtm_hits", null, contentValues);
            this.zzaQO.zzas(false);
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaE("Error storing hit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> zzjj(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            zzbg.zzaE("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.zzeG("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzaq> zzjk(int n) {
        ArrayList<zzaq> arrayList = new ArrayList<zzaq>();
        SQLiteDatabase sQLiteDatabase = this.zzeG("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_time", "hit_first_send_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    zzaq zzaq2 = new zzaq(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    arrayList.add(zzaq2);
                } while (cursor.moveToNext());
            }
        }
        int n2 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((zzaq)arrayList.get(n2)).zzeK(cursor.getString(1));
                    } else {
                        zzbg.zzaE(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((zzaq)arrayList.get(n2)).zzAe()));
                    }
                    ++n2;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaE("Error in peekHits fetching hit url: " + sQLiteException.getMessage());
            ArrayList<zzaq> arrayList2 = new ArrayList<zzaq>();
            boolean bl = false;
            for (zzaq zzaq3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)zzaq3.zzAg())) {
                    if (bl) break;
                    bl = true;
                }
                arrayList2.add(zzaq3);
            }
            ArrayList<zzaq> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int zziG() {
        long l = this.zzpO.currentTimeMillis();
        if (l <= this.zzaQQ + 86400000L) {
            return 0;
        }
        this.zzaQQ = l;
        SQLiteDatabase sQLiteDatabase = this.zzeG("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l2 = this.zzpO.currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("gtm_hits", "HIT_TIME < ?", new String[]{Long.toString(l2)});
        this.zzaQO.zzas(this.zzAs() == 0);
        return n;
    }

    void zzf(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.zzeG("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("gtm_hits", string, stringArray);
            this.zzaQO.zzas(this.zzAs() == 0);
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaE("Error deleting hits");
        }
    }

    private void zzq(long l) {
        this.zzf(new String[]{String.valueOf(l)});
    }

    private void zzc(long l, long l2) {
        SQLiteDatabase sQLiteDatabase = this.zzeG("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_first_send_time", Long.valueOf(l2));
        try {
            sQLiteDatabase.update("gtm_hits", contentValues, "hit_id=?", new String[]{String.valueOf(l)});
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaE("Error setting HIT_FIRST_DISPATCH_TIME for hitId: " + l);
            this.zzq(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzAs() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzeG("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from gtm_hits", null);
            if (cursor.moveToFirst()) {
                n = (int)cursor.getLong(0);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int zzAt() {
        int n = 0;
        SQLiteDatabase sQLiteDatabase = this.zzeG("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_first_send_time"}, "hit_first_send_time=0", null, null, null, null);
            n = cursor.getCount();
        }
        return n;
    }

    @Override
    public void dispatch() {
        zzbg.v("GTM Dispatch running...");
        if (!this.zzaQN.zzzX()) {
            return;
        }
        List<zzaq> list = this.zzjk(40);
        if (list.isEmpty()) {
            zzbg.v("...nothing to dispatch");
            this.zzaQO.zzas(true);
            return;
        }
        this.zzaQN.zzr(list);
        if (this.zzAt() > 0) {
            zzcu.zzAP().dispatch();
        }
    }

    private SQLiteDatabase zzeG(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.zzaQM.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            zzbg.zzaE(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class zzb
    extends SQLiteOpenHelper {
        private boolean zzaQT;
        private long zzaQU;

        zzb(Context context, String string) {
            super(context, string, null, 1);
            this.zzaQU = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.zzaQT && this.zzaQU + 3600000L > zzby.this.zzpO.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.zzaQT = true;
            this.zzaQU = zzby.this.zzpO.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzby.this.mContext.getDatabasePath(zzby.this.zzaQP).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.zzaQT = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza("gtm_hits", db)) {
                db.execSQL(zzMg);
            } else {
                this.zzc(db);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zzc(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM gtm_hits WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_time") && hashSet.remove("hit_first_send_time"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db) {
            zzal.zzbj(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }

    class zza
    implements zzcx.zza {
        zza() {
        }

        @Override
        public void zza(zzaq zzaq2) {
            zzby.this.zzq(zzaq2.zzAe());
        }

        @Override
        public void zzb(zzaq zzaq2) {
            zzby.this.zzq(zzaq2.zzAe());
            zzbg.v("Permanent failure dispatching hitId: " + zzaq2.zzAe());
        }

        @Override
        public void zzc(zzaq zzaq2) {
            long l = zzaq2.zzAf();
            if (l == 0L) {
                zzby.this.zzc(zzaq2.zzAe(), zzby.this.zzpO.currentTimeMillis());
            } else if (l + 14400000L < zzby.this.zzpO.currentTimeMillis()) {
                zzby.this.zzq(zzaq2.zzAe());
                zzbg.v("Giving up on failed hitId: " + zzaq2.zzAe());
            }
        }
    }
}

