/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.tagmanager.ContainerHolder;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzct;
import com.google.android.gms.tagmanager.zzcu;
import com.google.android.gms.tagmanager.zzd;
import com.google.android.gms.tagmanager.zzo;
import com.google.android.gms.tagmanager.zzp;
import com.google.android.gms.tagmanager.zzs;
import com.google.android.gms.tagmanager.zzw;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final zza zzaSs;
    private final Context mContext;
    private final DataLayer zzaOT;
    private final zzct zzaSt;
    private final ConcurrentMap<zzo, Boolean> zzaSu;
    private final zzs zzaRp;
    private static TagManager zzaSv;

    TagManager(Context context, zza containerHolderLoaderProvider, DataLayer dataLayer, zzct serviceManager) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.zzaSt = serviceManager;
        this.zzaSs = containerHolderLoaderProvider;
        this.zzaSu = new ConcurrentHashMap<zzo, Boolean>();
        this.zzaOT = dataLayer;
        this.zzaOT.zza(new DataLayer.zzb(){

            @Override
            public void zzH(Map<String, Object> map) {
                Object object = map.get("event");
                if (object != null) {
                    TagManager.this.zzeU(object.toString());
                }
            }
        });
        this.zzaOT.zza(new zzd(this.mContext));
        this.zzaRp = new zzs();
        this.zzAU();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (zzaSv == null) {
                if (context == null) {
                    zzbg.e("TagManager.getInstance requires non-null context.");
                    throw new NullPointerException();
                }
                zza zza2 = new zza(){

                    @Override
                    public zzp zza(Context context, TagManager tagManager, Looper looper, String string, int n, zzs zzs2) {
                        return new zzp(context, tagManager, looper, string, n, zzs2);
                    }
                };
                zzw zzw2 = new zzw(context);
                zzaSv = new TagManager(context, zza2, new DataLayer(zzw2), zzcu.zzAP());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaSv;
        }
    }

    public DataLayer getDataLayer() {
        return this.zzaOT;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaSs.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaRp);
        zzp2.zzzH();
        return zzp2;
    }

    public PendingResult<ContainerHolder> zzc(String string, int n, String string2) {
        zzp zzp2 = this.zzaSs.zza(this.mContext, this, null, string, n, this.zzaRp);
        zzp2.load(string2);
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaSs.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaRp);
        zzp2.zzzH();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaSs.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaRp);
        zzp2.zzzI();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaSs.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaRp);
        zzp2.zzzI();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaSs.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaRp);
        zzp2.zzzJ();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaSs.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaRp);
        zzp2.zzzJ();
        return zzp2;
    }

    public void dispatch() {
        this.zzaSt.dispatch();
    }

    public void setVerboseLoggingEnabled(boolean enableVerboseLogging) {
        zzbg.setLogLevel(enableVerboseLogging ? 2 : 5);
    }

    synchronized boolean zzm(Uri uri) {
        zzcb zzcb2 = zzcb.zzAv();
        if (zzcb2.zzm(uri)) {
            String string = zzcb2.getContainerId();
            switch (zzcb2.zzAw()) {
                case zzaRc: {
                    for (zzo zzo2 : this.zzaSu.keySet()) {
                        if (!zzo2.getContainerId().equals(string)) continue;
                        zzo2.zzey(null);
                        zzo2.refresh();
                    }
                    break;
                }
                case zzaRd: 
                case zzaRe: {
                    for (zzo zzo3 : this.zzaSu.keySet()) {
                        if (zzo3.getContainerId().equals(string)) {
                            zzo3.zzey(zzcb2.zzAx());
                            zzo3.refresh();
                            continue;
                        }
                        if (zzo3.zzzE() == null) continue;
                        zzo3.zzey(null);
                        zzo3.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    void zza(zzo zzo2) {
        this.zzaSu.put(zzo2, true);
    }

    boolean zzb(zzo zzo2) {
        return this.zzaSu.remove(zzo2) != null;
    }

    private void zzeU(String string) {
        for (zzo zzo2 : this.zzaSu.keySet()) {
            zzo2.zzew(string);
        }
    }

    private void zzAU() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int i) {
                    if (i == 20) {
                        TagManager.this.dispatch();
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    public static interface zza {
        public zzp zza(Context var1, TagManager var2, Looper var3, String var4, int var5, zzs var6);
    }
}

