/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.internal.zzav;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzoa;
    zzav zzob;
    boolean zzoc;
    Object zzod = new Object();
    zza zzoe;
    private final Context mContext;
    final long zzof;
    private static boolean zzog = false;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L);
    }

    public AdvertisingIdClient(Context context, long timeoutInMillis) {
        zzx.zzv((Object)context);
        this.mContext = context;
        this.zzoc = false;
        this.zzof = timeoutInMillis;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzb(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzb(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzx.zzci((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzoc) {
                this.finish();
            }
            this.zzoa = AdvertisingIdClient.zzo(this.mContext);
            this.zzob = AdvertisingIdClient.zza(this.mContext, this.zzoa);
            this.zzoc = true;
            if (bl) {
                this.zzaJ();
            }
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean shouldSkipGmsCoreVersionCheck) {
        zzog = shouldSkipGmsCoreVersionCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzaJ() {
        Object object = this.zzod;
        synchronized (object) {
            if (this.zzoe != null) {
                this.zzoe.cancel();
                try {
                    this.zzoe.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.zzof > 0L) {
                this.zzoe = new zza(this, this.zzof);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        zzx.zzci((String)"Calling this from your main thread can lead to deadlock");
        Info info = null;
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzoc) {
                Object object = this.zzod;
                synchronized (object) {
                    if (this.zzoe == null || !this.zzoe.zzaK()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zzb(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzoc) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzx.zzv((Object)this.zzoa);
            zzx.zzv((Object)this.zzob);
            try {
                info = new Info(this.zzob.getId(), this.zzob.zzc(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzaJ();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzx.zzci((String)"Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzoa == null) {
                return;
            }
            try {
                if (this.zzoc) {
                    zzb.zzpD().zza(this.mContext, (ServiceConnection)this.zzoa);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            this.zzoc = false;
            this.zzob = null;
            this.zzoa = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzo(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        if (zzog) {
            Log.d((String)"Ads", (String)"Skipping gmscore version check");
            int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            switch (n) {
                case 0: 
                case 2: {
                    break;
                }
                default: {
                    throw new IOException("Google Play services not available");
                }
            }
        } else {
            try {
                GooglePlayServicesUtil.zzaa((Context)context);
            }
            catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                throw new IOException(googlePlayServicesNotAvailableException);
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (zzb.zzpD().zza(context, intent, (ServiceConnection)zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L);
        try {
            advertisingIdClient.zzb(false);
            Info info = advertisingIdClient.getInfo();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static zzav zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzav.zza.zzb(zza2.zzmS());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzol;
        private final boolean zzom;

        public Info(String advertisingId, boolean limitAdTrackingEnabled) {
            this.zzol = advertisingId;
            this.zzom = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.zzol;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzom;
        }

        public String toString() {
            return "{" + this.zzol + "}" + this.zzom;
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzoh;
        private long zzoi;
        CountDownLatch zzoj;
        boolean zzok;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzoh = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzoi = l;
            this.zzoj = new CountDownLatch(1);
            this.zzok = false;
            this.start();
        }

        public void cancel() {
            this.zzoj.countDown();
        }

        public boolean zzaK() {
            return this.zzok;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzoh.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzok = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzoj.await(this.zzoi, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

