/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Pair;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableEvent;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.ProgressEvent;
import com.google.android.gms.drive.events.QueryResultEventParcelable;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzf;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.drive.events.zzl;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzy;
import java.util.ArrayList;
import java.util.List;

public class zzad
extends zzan.zza {
    private final int zzafk;
    private final zzf zzajf;
    private final zza zzajg;
    private final List<Integer> zzajh = new ArrayList<Integer>();

    public zzad(Looper looper, Context context, int n, zzf zzf2) {
        this.zzafk = n;
        this.zzajf = zzf2;
        this.zzajg = new zza(looper, context);
    }

    public void zzcJ(int n) {
        this.zzajh.add(n);
    }

    public boolean zzcK(int n) {
        return this.zzajh.contains(n);
    }

    @Override
    public void zzc(OnEventResponse onEventResponse) throws RemoteException {
        DriveEvent driveEvent = onEventResponse.zzqS();
        zzx.zzY((this.zzafk == driveEvent.getType() ? 1 : 0) != 0);
        zzx.zzY((boolean)this.zzajh.contains(driveEvent.getType()));
        this.zzajg.zza(this.zzajf, driveEvent);
    }

    private static class zza
    extends Handler {
        private final Context mContext;

        private zza(Looper looper, Context context) {
            super(looper);
            this.mContext = context;
        }

        public void zza(zzf zzf2, DriveEvent driveEvent) {
            this.sendMessage(this.obtainMessage(1, new Pair((Object)zzf2, (Object)driveEvent)));
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    zzf zzf2 = (zzf)pair.first;
                    DriveEvent driveEvent = (DriveEvent)pair.second;
                    switch (driveEvent.getType()) {
                        case 1: {
                            ((ChangeListener)zzf2).onChange((ChangeEvent)driveEvent);
                            break;
                        }
                        case 2: {
                            ((CompletionListener)zzf2).onCompletion((CompletionEvent)driveEvent);
                            break;
                        }
                        case 3: {
                            zza.zza((zzl)zzf2, (QueryResultEventParcelable)driveEvent);
                            break;
                        }
                        case 4: {
                            ((zzc)zzf2).zza((ChangesAvailableEvent)driveEvent);
                            break;
                        }
                        case 5: 
                        case 6: {
                            ((zzi)zzf2).zza((ProgressEvent)driveEvent);
                            break;
                        }
                        default: {
                            zzy.zzw("EventCallback", "Unexpected event: " + driveEvent);
                        }
                    }
                    return;
                }
            }
            zzy.zzf(this.mContext, "EventCallback", "Don't know how to handle this event");
        }

        private static void zza(zzl zzl2, QueryResultEventParcelable queryResultEventParcelable) {
            DataHolder dataHolder = queryResultEventParcelable.zzqA();
            if (dataHolder != null) {
                final MetadataBuffer metadataBuffer = new MetadataBuffer(dataHolder);
                zzl2.zza(new zzj(){});
            }
            if (queryResultEventParcelable.zzqB()) {
                zzl2.zzcs(queryResultEventParcelable.zzqC());
            }
        }
    }
}

