/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.internal.OpenFileIntentSenderRequest;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.internal.FilterHolder;
import com.google.android.gms.drive.query.internal.zzg;

public class OpenFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private String zzagU;
    private String[] zzagV;
    private Filter zzagW;
    private DriveId zzagX;

    public OpenFileActivityBuilder setActivityTitle(String title) {
        this.zzagU = (String)zzx.zzv((Object)title);
        return this;
    }

    public OpenFileActivityBuilder setMimeType(String[] mimeTypes) {
        zzx.zzb((mimeTypes != null ? 1 : 0) != 0, (Object)"mimeTypes may not be null");
        this.zzagV = mimeTypes;
        return this;
    }

    public OpenFileActivityBuilder setSelectionFilter(Filter filter) {
        zzx.zzb((filter != null ? 1 : 0) != 0, (Object)"filter may not be null");
        zzx.zzb((!zzg.zza(filter) ? 1 : 0) != 0, (Object)"FullTextSearchFilter cannot be used as a selection filter");
        this.zzagW = filter;
        return this;
    }

    public OpenFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzagX = (DriveId)zzx.zzv((Object)folder);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzx.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        if (this.zzagV == null) {
            this.zzagV = new String[0];
        }
        if (this.zzagV.length > 0 && this.zzagW != null) {
            throw new IllegalStateException("Cannot use a selection filter and set mimetypes simultaneously");
        }
        FilterHolder filterHolder = this.zzagW == null ? null : new FilterHolder(this.zzagW);
        try {
            zzal zzal2 = ((zzt)apiClient.zza(Drive.zzQf)).zzqF();
            return zzal2.zza(new OpenFileIntentSenderRequest(this.zzagU, this.zzagV, this.zzagX, filterHolder));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Unable to connect Drive Play Service", remoteException);
        }
    }
}

