/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.client.zzd;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzhu;
import java.util.HashMap;

@zzgk
public class zzgx
extends com.google.android.gms.ads.internal.zzb
implements zzhb {
    private zzd zzGg;
    private String zzGh;
    private boolean zzGi;
    private HashMap<String, zzgy> zzGj = new HashMap();

    public zzgx(Context context, AdSizeParcel adSizeParcel, zzeh zzeh2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzeh2, versionInfoParcel, null);
    }

    public void setUserId(String userId) {
        zzx.zzch((String)"setUserId must be called on the main UI thread.");
        this.zzGh = userId;
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzx.zzch((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzpZ)) {
            zzb.zzaE("Invalid ad unit id. Aborting.");
            return;
        }
        this.zzGi = false;
        this.zzos.zzpZ = rewardedVideoAdRequestParcel.zzpZ;
        super.zza(rewardedVideoAdRequestParcel.zzDy);
    }

    @Override
    public void zza(final zzhj.zza zza2, zzcd zzcd2) {
        if (zza2.errorCode != -2) {
            zzhu.zzHK.post(new Runnable(){

                @Override
                public void run() {
                    zzgx.this.zzb(new zzhj(zza2, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzos.zzqz = 0;
        this.zzos.zzqe = new zzhe(this.zzos.context, this.zzGh, zza2, this);
        zzb.zzaC("AdRenderer: " + this.zzos.zzqe.getClass().getName());
        this.zzos.zzqe.zzgn();
    }

    public zzgy zzar(String string2) {
        zzgy zzgy2 = this.zzGj.get(string2);
        if (zzgy2 == null) {
            try {
                zzgy2 = new zzgy(this.zzow.zzab(string2), this);
                this.zzGj.put(string2, zzgy2);
            }
            catch (Exception exception) {
                zzb.zzd("Fail to instantiate adapter " + string2, exception);
            }
        }
        return zzgy2;
    }

    @Override
    public boolean zza(zzhj zzhj2, zzhj zzhj3) {
        if (this.zzGg != null) {
            try {
                this.zzGg.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call RewardedVideoAdListener.onAdLoaded().", remoteException);
            }
        }
        return true;
    }

    @Override
    public void pause() {
        zzx.zzch((String)"pause must be called on the main UI thread.");
        for (String string2 : this.zzGj.keySet()) {
            try {
                zzgy zzgy2 = this.zzGj.get(string2);
                if (zzgy2 == null || zzgy2.zzfQ() == null) continue;
                zzgy2.zzfQ().pause();
            }
            catch (RemoteException remoteException) {
                zzb.zzaE("Fail to pause adapter: " + string2);
            }
        }
    }

    @Override
    public void resume() {
        zzx.zzch((String)"resume must be called on the main UI thread.");
        for (String string2 : this.zzGj.keySet()) {
            try {
                zzgy zzgy2 = this.zzGj.get(string2);
                if (zzgy2 == null || zzgy2.zzfQ() == null) continue;
                zzgy2.zzfQ().resume();
            }
            catch (RemoteException remoteException) {
                zzb.zzaE("Fail to resume adapter: " + string2);
            }
        }
    }

    @Override
    public void destroy() {
        zzx.zzch((String)"destroy must be called on the main UI thread.");
        for (String string2 : this.zzGj.keySet()) {
            try {
                zzgy zzgy2 = this.zzGj.get(string2);
                if (zzgy2 == null || zzgy2.zzfQ() == null) continue;
                zzgy2.zzfQ().destroy();
            }
            catch (RemoteException remoteException) {
                zzb.zzaE("Fail to destroy adapter: " + string2);
            }
        }
    }

    @Override
    protected boolean zze(int n) {
        zzb.zzaE("Failed to load ad: " + n);
        if (this.zzGg == null) {
            return false;
        }
        try {
            this.zzGg.onRewardedVideoAdFailedToLoad(n);
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdFailedToLoad().", remoteException);
            return false;
        }
    }

    public void zzfO() {
        zzx.zzch((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzb.zzaE("The reward video has not loaded.");
            return;
        }
        this.zzGi = true;
        zzgy zzgy2 = this.zzar(this.zzos.zzqg.zzyS);
        if (zzgy2 != null && zzgy2.zzfQ() != null) {
            try {
                zzgy2.zzfQ().showVideo();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call showVideo.", remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzx.zzch((String)"isLoaded must be called on the main UI thread.");
        return this.zzos.zzqd == null && this.zzos.zzqe == null && this.zzos.zzqg != null && !this.zzGi;
    }

    public void zza(zzd zzd2) {
        zzx.zzch((String)"setRewardedVideoAdListener must be called on the main UI thread.");
        this.zzGg = zzd2;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzos.zzqg, false);
        if (this.zzGg == null) {
            return;
        }
        try {
            this.zzGg.onRewardedVideoAdOpened();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdOpened().", remoteException);
        }
    }

    @Override
    public void onRewardedVideoStarted() {
        zzp.zzbJ().zza(this.zzos.context, this.zzos.zzqb.zzIz, this.zzos.zzqg, this.zzos.zzpZ, false, this.zzos.zzqg.zzyQ.zzys);
        if (this.zzGg == null) {
            return;
        }
        try {
            this.zzGg.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onVideoStarted().", remoteException);
        }
    }

    @Override
    public void onRewardedVideoAdClosed() {
        if (this.zzGg == null) {
            return;
        }
        try {
            this.zzGg.onRewardedVideoAdClosed();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdClosed().", remoteException);
        }
    }

    @Override
    public void zza(RewardItemParcel rewardItemParcel) {
        zzp.zzbJ().zza(this.zzos.context, this.zzos.zzqb.zzIz, this.zzos.zzqg, this.zzos.zzpZ, false, this.zzos.zzqg.zzyQ.zzyt);
        if (this.zzGg == null) {
            return;
        }
        try {
            if (this.zzos.zzqg != null && this.zzos.zzqg.zzGG != null && !TextUtils.isEmpty((CharSequence)this.zzos.zzqg.zzGG.zzyB)) {
                this.zzGg.zza(new zzgv(this.zzos.zzqg.zzGG.zzyB, this.zzos.zzqg.zzGG.zzyC));
            } else {
                this.zzGg.zza(new zzgv(rewardItemParcel.type, rewardItemParcel.zzGE));
            }
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onRewarded().", remoteException);
        }
    }

    @Override
    public void zzfP() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        if (this.zzGg == null) {
            return;
        }
        try {
            this.zzGg.onRewardedVideoAdLeftApplication();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdLeftApplication().", remoteException);
        }
    }
}

