/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class zzac
implements DataItem {
    private Uri mUri;
    private byte[] zzayG;
    private Map<String, DataItemAsset> zzbap;

    public zzac(DataItem dataItem) {
        this.mUri = dataItem.getUri();
        this.zzayG = dataItem.getData();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, DataItemAsset> entry : dataItem.getAssets().entrySet()) {
            if (entry.getKey() == null) continue;
            hashMap.put(entry.getKey(), entry.getValue().freeze());
        }
        this.zzbap = Collections.unmodifiableMap(hashMap);
    }

    public DataItem zzCG() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    @Override
    public Uri getUri() {
        return this.mUri;
    }

    @Override
    public byte[] getData() {
        return this.zzayG;
    }

    @Override
    public Map<String, DataItemAsset> getAssets() {
        return this.zzbap;
    }

    @Override
    public DataItem setData(byte[] data) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataItem", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("DataItemEntity{ ");
        stringBuilder.append("uri=" + this.mUri);
        stringBuilder.append(", dataSz=" + (this.zzayG == null ? "null" : Integer.valueOf(this.zzayG.length)));
        stringBuilder.append(", numAssets=" + this.zzbap.size());
        if (verbose && !this.zzbap.isEmpty()) {
            stringBuilder.append(", assets=[");
            String string = "";
            for (Map.Entry<String, DataItemAsset> entry : this.zzbap.entrySet()) {
                stringBuilder.append(string + entry.getKey() + ": " + entry.getValue().getId());
                string = ", ";
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzCG();
    }
}

