/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor zzaHc;
    private LatLng zzaHd;
    private float zzaHe;
    private float zzaHf;
    private LatLngBounds zzaHg;
    private float zzaGS;
    private float zzaGZ;
    private boolean zzaHa = true;
    private float zzaHh = 0.0f;
    private float zzaHi = 0.5f;
    private float zzaHj = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.mVersionCode = versionCode;
        this.zzaHc = new BitmapDescriptor(zzd.zza.zzbk((IBinder)wrappedImage));
        this.zzaHd = location;
        this.zzaHe = width;
        this.zzaHf = height;
        this.zzaHg = bounds;
        this.zzaGS = bearing;
        this.zzaGZ = zIndex;
        this.zzaHa = visible;
        this.zzaHh = transparency;
        this.zzaHi = anchorU;
        this.zzaHj = anchorV;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    IBinder zzxc() {
        return this.zzaHc.zzwB().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.zzaHc = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u, float v) {
        this.zzaHi = u;
        this.zzaHj = v;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        zzx.zza((this.zzaHg == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        zzx.zza((this.zzaHg == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzx.zzb((height >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(location, width, height);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzaHd = latLng;
        this.zzaHe = f;
        this.zzaHf = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        zzx.zza((this.zzaHd == null ? 1 : 0) != 0, (Object)("Position has already been set using position: " + this.zzaHd));
        this.zzaHg = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.zzaGS = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.zzaGZ = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.zzaHa = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        zzx.zzb((transparency >= 0.0f && transparency <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzaHh = transparency;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.zzaHc;
    }

    public LatLng getLocation() {
        return this.zzaHd;
    }

    public float getWidth() {
        return this.zzaHe;
    }

    public float getHeight() {
        return this.zzaHf;
    }

    public LatLngBounds getBounds() {
        return this.zzaHg;
    }

    public float getBearing() {
        return this.zzaGS;
    }

    public float getZIndex() {
        return this.zzaGZ;
    }

    public float getTransparency() {
        return this.zzaHh;
    }

    public float getAnchorU() {
        return this.zzaHi;
    }

    public float getAnchorV() {
        return this.zzaHj;
    }

    public boolean isVisible() {
        return this.zzaHa;
    }
}

