/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.zza;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final zza CREATOR = new zza();
    private final int mVersionCode;
    private Boolean zzaFI;
    private Boolean zzaFJ;
    private int zzaFK = -1;
    private CameraPosition zzaFL;
    private Boolean zzaFM;
    private Boolean zzaFN;
    private Boolean zzaFO;
    private Boolean zzaFP;
    private Boolean zzaFQ;
    private Boolean zzaFR;
    private Boolean zzaFS;
    private Boolean zzaFT;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled, byte liteMode, byte mapToolbarEnabled) {
        this.mVersionCode = versionCode;
        this.zzaFI = com.google.android.gms.maps.internal.zza.zza(zOrderOnTop);
        this.zzaFJ = com.google.android.gms.maps.internal.zza.zza(useViewLifecycleInFragment);
        this.zzaFK = mapType;
        this.zzaFL = camera;
        this.zzaFM = com.google.android.gms.maps.internal.zza.zza(zoomControlsEnabled);
        this.zzaFN = com.google.android.gms.maps.internal.zza.zza(compassEnabled);
        this.zzaFO = com.google.android.gms.maps.internal.zza.zza(scrollGesturesEnabled);
        this.zzaFP = com.google.android.gms.maps.internal.zza.zza(zoomGesturesEnabled);
        this.zzaFQ = com.google.android.gms.maps.internal.zza.zza(tiltGesturesEnabled);
        this.zzaFR = com.google.android.gms.maps.internal.zza.zza(rotateGesturesEnabled);
        this.zzaFS = com.google.android.gms.maps.internal.zza.zza(liteMode);
        this.zzaFT = com.google.android.gms.maps.internal.zza.zza(mapToolbarEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzwE() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFI);
    }

    byte zzwF() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFJ);
    }

    byte zzwG() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFM);
    }

    byte zzwH() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFN);
    }

    byte zzwI() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFO);
    }

    byte zzwJ() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFP);
    }

    byte zzwK() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFQ);
    }

    byte zzwL() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFR);
    }

    byte zzwM() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFS);
    }

    byte zzwN() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaFT);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.zzaFI = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.zzaFJ = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.zzaFK = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.zzaFL = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.zzaFM = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.zzaFN = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.zzaFO = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zzaFP = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.zzaFQ = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.zzaFR = enabled;
        return this;
    }

    public GoogleMapOptions liteMode(boolean enabled) {
        this.zzaFS = enabled;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean enabled) {
        this.zzaFT = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzaFI;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzaFJ;
    }

    public int getMapType() {
        return this.zzaFK;
    }

    public CameraPosition getCamera() {
        return this.zzaFL;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzaFM;
    }

    public Boolean getCompassEnabled() {
        return this.zzaFN;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzaFO;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzaFP;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzaFQ;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzaFR;
    }

    public Boolean getLiteMode() {
        return this.zzaFS;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzaFT;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

