/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzrx;
import com.google.android.gms.internal.zzsa;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public final class zzrq {
    private final ByteBuffer zzbbZ;

    private zzrq(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzrq(ByteBuffer byteBuffer) {
        this.zzbbZ = byteBuffer;
    }

    public static zzrq zzA(byte[] byArray) {
        return zzrq.zzb(byArray, 0, byArray.length);
    }

    public static zzrq zzb(byte[] byArray, int n, int n2) {
        return new zzrq(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzD(n, 1);
        this.zzi(d);
    }

    public void zzb(int n, float f) throws IOException {
        this.zzD(n, 5);
        this.zzi(f);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzD(n, 0);
        this.zzW(l);
    }

    public void zzz(int n, int n2) throws IOException {
        this.zzD(n, 0);
        this.zzlq(n2);
    }

    public void zzb(int n, boolean bl) throws IOException {
        this.zzD(n, 0);
        this.zzaw(bl);
    }

    public void zzb(int n, String string2) throws IOException {
        this.zzD(n, 2);
        this.zzfx(string2);
    }

    public void zza(int n, zzrx zzrx2) throws IOException {
        this.zzD(n, 2);
        this.zzc(zzrx2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzD(n, 2);
        this.zzB(byArray);
    }

    public void zzA(int n, int n2) throws IOException {
        this.zzD(n, 0);
        this.zzlr(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzD(n, 0);
        this.zzX(l);
    }

    public void zzi(double d) throws IOException {
        this.zzac(Double.doubleToLongBits(d));
    }

    public void zzi(float f) throws IOException {
        this.zzly(Float.floatToIntBits(f));
    }

    public void zzW(long l) throws IOException {
        this.zzaa(l);
    }

    public void zzlq(int n) throws IOException {
        if (n >= 0) {
            this.zzlw(n);
        } else {
            this.zzaa(n);
        }
    }

    public void zzaw(boolean bl) throws IOException {
        this.zzlu(bl ? 1 : 0);
    }

    public void zzfx(String string2) throws IOException {
        try {
            int n = zzrq.zzlx(string2.length());
            int n2 = zzrq.zzlx(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzbbZ.position();
                this.zzbbZ.position(n3 + n);
                zzrq.zza((CharSequence)string2, this.zzbbZ);
                int n4 = this.zzbbZ.position();
                this.zzbbZ.position(n3);
                this.zzlw(n4 - n3 - n);
                this.zzbbZ.position(n4);
            } else {
                this.zzlw(zzrq.zzc(string2));
                zzrq.zza((CharSequence)string2, this.zzbbZ);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new zza(this.zzbbZ.position(), this.zzbbZ.limit());
        }
    }

    private static int zzc(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzrq.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzrq.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzrq.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            int n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                char c2;
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (n3 - 1));
                }
                int n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzrx zzrx2) throws IOException {
        zzrx2.zza(this);
    }

    public void zzc(zzrx zzrx2) throws IOException {
        this.zzlw(zzrx2.zzDw());
        zzrx2.zza(this);
    }

    public void zzB(byte[] byArray) throws IOException {
        this.zzlw(byArray.length);
        this.zzD(byArray);
    }

    public void zzlr(int n) throws IOException {
        this.zzlw(zzrq.zzlz(n));
    }

    public void zzX(long l) throws IOException {
        this.zzaa(zzrq.zzad(l));
    }

    public static int zzb(int n, double d) {
        return zzrq.zzlv(n) + zzrq.zzj(d);
    }

    public static int zzc(int n, float f) {
        return zzrq.zzlv(n) + zzrq.zzj(f);
    }

    public static int zzd(int n, long l) {
        return zzrq.zzlv(n) + zzrq.zzY(l);
    }

    public static int zzB(int n, int n2) {
        return zzrq.zzlv(n) + zzrq.zzls(n2);
    }

    public static int zzc(int n, boolean bl) {
        return zzrq.zzlv(n) + zzrq.zzax(bl);
    }

    public static int zzl(int n, String string2) {
        return zzrq.zzlv(n) + zzrq.zzfy(string2);
    }

    public static int zzb(int n, zzrx zzrx2) {
        return zzrq.zzlv(n) * 2 + zzrq.zzd(zzrx2);
    }

    public static int zzc(int n, zzrx zzrx2) {
        return zzrq.zzlv(n) + zzrq.zze(zzrx2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzrq.zzlv(n) + zzrq.zzC(byArray);
    }

    public static int zzC(int n, int n2) {
        return zzrq.zzlv(n) + zzrq.zzlt(n2);
    }

    public static int zze(int n, long l) {
        return zzrq.zzlv(n) + zzrq.zzZ(l);
    }

    public static int zzj(double d) {
        return 8;
    }

    public static int zzj(float f) {
        return 4;
    }

    public static int zzY(long l) {
        return zzrq.zzab(l);
    }

    public static int zzls(int n) {
        if (n >= 0) {
            return zzrq.zzlx(n);
        }
        return 10;
    }

    public static int zzax(boolean bl) {
        return 1;
    }

    public static int zzfy(String string2) {
        int n = zzrq.zzc(string2);
        return zzrq.zzlx(n) + n;
    }

    public static int zzd(zzrx zzrx2) {
        return zzrx2.zzDx();
    }

    public static int zze(zzrx zzrx2) {
        int n = zzrx2.zzDx();
        return zzrq.zzlx(n) + n;
    }

    public static int zzC(byte[] byArray) {
        return zzrq.zzlx(byArray.length) + byArray.length;
    }

    public static int zzlt(int n) {
        return zzrq.zzlx(zzrq.zzlz(n));
    }

    public static int zzZ(long l) {
        return zzrq.zzab(zzrq.zzad(l));
    }

    public int zzDi() {
        return this.zzbbZ.remaining();
    }

    public void zzDj() {
        if (this.zzDi() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzb(byte by) throws IOException {
        if (!this.zzbbZ.hasRemaining()) {
            throw new zza(this.zzbbZ.position(), this.zzbbZ.limit());
        }
        this.zzbbZ.put(by);
    }

    public void zzlu(int n) throws IOException {
        this.zzb((byte)n);
    }

    public void zzD(byte[] byArray) throws IOException {
        this.zzc(byArray, 0, byArray.length);
    }

    public void zzc(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzbbZ.remaining() < n2) {
            throw new zza(this.zzbbZ.position(), this.zzbbZ.limit());
        }
        this.zzbbZ.put(byArray, n, n2);
    }

    public void zzD(int n, int n2) throws IOException {
        this.zzlw(zzsa.zzE(n, n2));
    }

    public static int zzlv(int n) {
        return zzrq.zzlx(zzsa.zzE(n, 0));
    }

    public void zzlw(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzlu(n);
                return;
            }
            this.zzlu(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzlx(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzaa(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzlu((int)l);
                return;
            }
            this.zzlu((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzab(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzly(int n) throws IOException {
        this.zzlu(n & 0xFF);
        this.zzlu(n >> 8 & 0xFF);
        this.zzlu(n >> 16 & 0xFF);
        this.zzlu(n >> 24 & 0xFF);
    }

    public void zzac(long l) throws IOException {
        this.zzlu((int)l & 0xFF);
        this.zzlu((int)(l >> 8) & 0xFF);
        this.zzlu((int)(l >> 16) & 0xFF);
        this.zzlu((int)(l >> 24) & 0xFF);
        this.zzlu((int)(l >> 32) & 0xFF);
        this.zzlu((int)(l >> 40) & 0xFF);
        this.zzlu((int)(l >> 48) & 0xFF);
        this.zzlu((int)(l >> 56) & 0xFF);
    }

    public static int zzlz(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzad(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + n + " limit " + n2 + ").");
        }
    }
}

