/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.ValidateAccountRequest;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.internal.zzx;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzj<T extends IInterface>
implements Api.zzb,
zzk.zza {
    private final Context mContext;
    private final com.google.android.gms.common.internal.zzf zzZH;
    private final Looper zzYV;
    private final zzl zzadu;
    private final GoogleApiAvailability zzZi;
    final Handler mHandler;
    private final Object zzpc = new Object();
    private zzs zzadv;
    private GoogleApiClient.zza zzadw;
    private T zzadx;
    private final ArrayList<zzc<?>> zzady = new ArrayList();
    private zze zzadz;
    private int zzadA = 1;
    private final Set<Scope> zzZp;
    private final Account zzOY;
    private final GoogleApiClient.ConnectionCallbacks zzadB;
    private final GoogleApiClient.OnConnectionFailedListener zzadC;
    private final int zzadD;
    protected AtomicInteger zzadE = new AtomicInteger(0);
    public static final String[] zzadF = new String[]{"service_esmobile", "service_googleme"};

    protected zzj(Context context, Looper looper, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, zzl.zzak(context), GoogleApiAvailability.getInstance(), n, zzf2, zzx.zzv(connectionCallbacks), zzx.zzv(onConnectionFailedListener));
    }

    protected zzj(Context context, Looper looper, zzl zzl2, GoogleApiAvailability googleApiAvailability, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.mContext = zzx.zzb(context, (Object)"Context must not be null");
        this.zzYV = zzx.zzb(looper, (Object)"Looper must not be null");
        this.zzadu = zzx.zzb(zzl2, (Object)"Supervisor must not be null");
        this.zzZi = zzx.zzb(googleApiAvailability, (Object)"API availability must not be null");
        this.mHandler = new zzb(looper);
        this.zzadD = n;
        this.zzZH = zzx.zzv(zzf2);
        this.zzOY = zzf2.getAccount();
        this.zzZp = this.zzb(zzf2.zzoj());
        this.zzadB = connectionCallbacks;
        this.zzadC = onConnectionFailedListener;
    }

    private Set<Scope> zzb(Set<Scope> set) {
        Set<Scope> set2 = this.zza(set);
        if (set2 == null) {
            return set2;
        }
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    protected Set<Scope> zza(Set<Scope> set) {
        return set;
    }

    protected abstract String zzfA();

    protected abstract String zzfB();

    protected final String zzot() {
        return this.zzZH.zzom();
    }

    protected abstract T zzV(IBinder var1);

    protected void zzou() {
    }

    protected void onConnectionSuspended(int cause) {
    }

    protected void onConnectionFailed(ConnectionResult result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzx.zzZ(n == 3 == (t != null));
        Object object = this.zzpc;
        synchronized (object) {
            this.zzadA = n;
            this.zzadx = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzov();
                    break;
                }
                case 3: {
                    this.zzou();
                    break;
                }
                case 1: {
                    this.zzow();
                }
            }
        }
    }

    protected void zzc(int n, T t) {
    }

    private void zzov() {
        if (this.zzadz != null) {
            Log.e((String)"GmsClient", (String)("Calling connect() while still connected, missing disconnect() for " + this.zzfA()));
            this.zzadu.zzb(this.zzfA(), (ServiceConnection)this.zzadz, this.zzot());
            this.zzadE.incrementAndGet();
        }
        this.zzadz = new zze(this.zzadE.get());
        boolean bl = this.zzadu.zza(this.zzfA(), (ServiceConnection)this.zzadz, this.zzot());
        if (!bl) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.zzfA()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzadE.get(), 9));
        }
    }

    private void zzow() {
        if (this.zzadz != null) {
            this.zzadu.zzb(this.zzfA(), (ServiceConnection)this.zzadz, this.zzot());
            this.zzadz = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzadA != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zzox() {
        int n = this.zzZi.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.zzadw = new zzf();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzadE.get(), n));
            return;
        }
        this.zza(new zzf());
    }

    @Override
    public void zza(GoogleApiClient.zza zza2) {
        this.zzadw = zzx.zzb(zza2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzadA == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzpc;
        synchronized (object) {
            return this.zzadA == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzadE.incrementAndGet();
        ArrayList<zzc<?>> arrayList = this.zzady;
        synchronized (arrayList) {
            int n = this.zzady.size();
            for (int i = 0; i < n; ++i) {
                this.zzady.get(i).zzoG();
            }
            this.zzady.clear();
        }
        this.zzb(1, null);
    }

    public void zzbz(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.zzadE.get(), n));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzYV;
    }

    public final Account zzog() {
        return this.zzOY != null ? this.zzOY : new Account("<<default account>>", "com.google");
    }

    protected final com.google.android.gms.common.internal.zzf zzoy() {
        return this.zzZH;
    }

    protected Bundle zzli() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzg(n, iBinder, bundle)));
    }

    protected void zza(int n, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzi(n, bundle)));
    }

    protected void zzbA(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, n, -1, (Object)new zzh()));
    }

    protected final void zzoz() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle zzmw() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzoA() throws DeadObjectException {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzadA == 4) {
                throw new DeadObjectException();
            }
            this.zzoz();
            zzx.zza(this.zzadx != null, (Object)"Client is connected but service is null");
            return this.zzadx;
        }
    }

    @Override
    public void zza(zzp zzp2) {
        Bundle bundle = this.zzoB();
        ValidateAccountRequest validateAccountRequest = new ValidateAccountRequest(zzp2, this.zzZp.toArray(new Scope[this.zzZp.size()]), this.mContext.getPackageName(), bundle);
        try {
            this.zzadv.zza((zzr)new zzd(this, this.zzadE.get()), validateAccountRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbz(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    protected Bundle zzoB() {
        return null;
    }

    @Override
    public void zza(zzp zzp2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzli();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzadD).zzck(this.mContext.getPackageName()).zzg(bundle);
            if (set != null) {
                getServiceRequest.zzd(set);
            }
            if (this.zzlm()) {
                getServiceRequest.zzb(this.zzog()).zzc(zzp2);
            } else if (this.zzoC()) {
                getServiceRequest.zzb(this.zzOY);
            }
            this.zzadv.zza((zzr)new zzd(this, this.zzadE.get()), getServiceRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbz(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    @Override
    public boolean zzlm() {
        return false;
    }

    public boolean zzoC() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        T t;
        int n;
        Object object = this.zzpc;
        synchronized (object) {
            n = this.zzadA;
            t = this.zzadx;
        }
        writer.append(prefix).append("mConnectState=");
        switch (n) {
            case 2: {
                writer.print("CONNECTING");
                break;
            }
            case 3: {
                writer.print("CONNECTED");
                break;
            }
            case 4: {
                writer.print("DISCONNECTING");
                break;
            }
            case 1: {
                writer.print("DISCONNECTED");
                break;
            }
            default: {
                writer.print("UNKNOWN");
            }
        }
        writer.append(" mService=");
        if (t == null) {
            writer.println("null");
        } else {
            writer.append(this.zzfB()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
    }

    public static final class zzd
    extends zzr.zza {
        private zzj zzadJ;
        private final int zzadK;

        public zzd(zzj zzj2, int n) {
            this.zzadJ = zzj2;
            this.zzadK = n;
        }

        @Override
        public void zzb(int n, Bundle bundle) {
            zzx.zzb(this.zzadJ, (Object)"onAccountValidationComplete can be called only once per call to validateAccount");
            this.zzadJ.zza(n, bundle, this.zzadK);
            this.zzoH();
        }

        @Override
        public void zza(int n, IBinder iBinder, Bundle bundle) {
            zzx.zzb(this.zzadJ, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzadJ.zza(n, iBinder, bundle, this.zzadK);
            this.zzoH();
        }

        private void zzoH() {
            this.zzadJ = null;
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        public final int statusCode;
        public final Bundle zzadG;

        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzadG = bundle;
        }

        protected abstract boolean zzoD();

        protected abstract void zzi(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzj.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzoD()) break;
                    zzj.this.zzb(1, null);
                    this.zzi(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzj.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzj.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzadG != null) {
                        pendingIntent = (PendingIntent)this.zzadG.getParcelable("pendingIntent");
                    }
                    this.zzi(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzoE() {
        }

        @Override
        protected /* synthetic */ void zzs(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzg
    extends zza {
        public final IBinder zzadL;

        public zzg(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzadL = iBinder;
        }

        @Override
        protected void zzi(ConnectionResult connectionResult) {
            if (zzj.this.zzadC != null) {
                zzj.this.zzadC.onConnectionFailed(connectionResult);
            }
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzoD() {
            String string2;
            try {
                string2 = this.zzadL.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzj.this.zzfB().equals(string2)) {
                Log.e((String)"GmsClient", (String)("service descriptor mismatch: " + zzj.this.zzfB() + " vs. " + string2));
                return false;
            }
            Object t = zzj.this.zzV(this.zzadL);
            if (t != null && zzj.this.zza(2, 3, t)) {
                Bundle bundle = zzj.this.zzmw();
                if (zzj.this.zzadB != null) {
                    zzj.this.zzadB.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzi
    extends zza {
        public zzi(int n, Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzi(ConnectionResult connectionResult) {
            zzj.this.zzadw.zzb(connectionResult);
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzoD() {
            zzj.this.zzadw.zzb(ConnectionResult.zzYi);
            return true;
        }
    }

    protected final class zzh
    extends zza {
        public zzh() {
            super(0, null);
        }

        @Override
        protected void zzi(ConnectionResult connectionResult) {
            zzj.this.zzadw.zza(connectionResult);
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzoD() {
            zzj.this.zzadw.zza(ConnectionResult.zzYi);
            return true;
        }
    }

    protected class zzf
    implements GoogleApiClient.zza {
        @Override
        public void zza(ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzj.this.zza(null, zzj.this.zzZp);
            } else if (zzj.this.zzadC != null) {
                zzj.this.zzadC.onConnectionFailed(connectionResult);
            }
        }

        @Override
        public void zzb(ConnectionResult connectionResult) {
            throw new IllegalStateException("Legacy GmsClient received onReportAccountValidation callback.");
        }
    }

    protected abstract class zzc<TListener> {
        private TListener mListener;
        private boolean zzadI;

        public zzc(TListener TListener) {
            this.mListener = TListener;
            this.zzadI = false;
        }

        protected abstract void zzs(TListener var1);

        protected abstract void zzoE();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzoF() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.mListener;
                if (this.zzadI) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.zzs(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzoE();
                    throw runtimeException;
                }
            } else {
                this.zzoE();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzadI = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzoG();
            ArrayList arrayList = zzj.this.zzady;
            synchronized (arrayList) {
                zzj.this.zzady.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzoG() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.mListener = null;
            }
        }
    }

    final class zzb
    extends Handler {
        public zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (zzj.this.zzadE.get() != msg.arg1) {
                if (this.zzb(msg)) {
                    this.zza(msg);
                }
                return;
            }
            if (!(msg.what != 1 && msg.what != 5 && msg.what != 6 || zzj.this.isConnecting())) {
                this.zza(msg);
                return;
            }
            if (msg.what == 3) {
                ConnectionResult connectionResult = new ConnectionResult(msg.arg2, null);
                zzj.this.zzadw.zza(connectionResult);
                zzj.this.onConnectionFailed(connectionResult);
                return;
            }
            if (msg.what == 4) {
                zzj.this.zzb(4, null);
                if (zzj.this.zzadB != null) {
                    zzj.this.zzadB.onConnectionSuspended(msg.arg2);
                }
                zzj.this.onConnectionSuspended(msg.arg2);
                zzj.this.zza(4, 1, null);
                return;
            }
            if (msg.what == 2 && !zzj.this.isConnected()) {
                this.zza(msg);
                return;
            }
            if (this.zzb(msg)) {
                zzc zzc2 = (zzc)msg.obj;
                zzc2.zzoF();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }

        private void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zzoE();
            zzc2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5 || message.what == 6;
        }
    }

    public final class zze
    implements ServiceConnection {
        private final int zzadK;

        public zze(int n) {
            this.zzadK = n;
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            zzx.zzb(binder, (Object)"Expecting a valid IBinder");
            zzj.this.zzadv = zzs.zza.zzaK(binder);
            zzj.this.zzbA(this.zzadK);
        }

        public void onServiceDisconnected(ComponentName component) {
            zzj.this.mHandler.sendMessage(zzj.this.mHandler.obtainMessage(4, this.zzadK, 1));
        }
    }
}

