/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;

public class AccountChangeEvent
implements SafeParcelable {
    public static final Parcelable.Creator<AccountChangeEvent> CREATOR = new zza();
    final int mVersion;
    final long zzQD;
    final String zzQE;
    final int zzQF;
    final int zzQG;
    final String zzQH;

    AccountChangeEvent(int version, long id, String accountName, int changeType, int eventIndex, String changeData) {
        this.mVersion = version;
        this.zzQD = id;
        this.zzQE = zzx.zzv(accountName);
        this.zzQF = changeType;
        this.zzQG = eventIndex;
        this.zzQH = changeData;
    }

    public AccountChangeEvent(long id, String accountName, int changeType, int eventIndex, String changeData) {
        this.mVersion = 1;
        this.zzQD = id;
        this.zzQE = zzx.zzv(accountName);
        this.zzQF = changeType;
        this.zzQG = eventIndex;
        this.zzQH = changeData;
    }

    public String getAccountName() {
        return this.zzQE;
    }

    public int getChangeType() {
        return this.zzQF;
    }

    public int getEventIndex() {
        return this.zzQG;
    }

    public String getChangeData() {
        return this.zzQH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }

    public String toString() {
        String string = "UNKNOWN";
        switch (this.zzQF) {
            case 1: {
                string = "ADDED";
                break;
            }
            case 2: {
                string = "REMOVED";
                break;
            }
            case 4: {
                string = "RENAMED_TO";
                break;
            }
            case 3: {
                string = "RENAMED_FROM";
            }
        }
        return "AccountChangeEvent {accountName = " + this.zzQE + ", changeType = " + string + ", changeData = " + this.zzQH + ", eventIndex = " + this.zzQG + "}";
    }

    public int hashCode() {
        return zzw.hashCode(this.mVersion, this.zzQD, this.zzQE, this.zzQF, this.zzQG, this.zzQH);
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof AccountChangeEvent) {
            AccountChangeEvent accountChangeEvent = (AccountChangeEvent)that;
            return this.mVersion == accountChangeEvent.mVersion && this.zzQD == accountChangeEvent.zzQD && zzw.equal(this.zzQE, accountChangeEvent.zzQE) && this.zzQF == accountChangeEvent.zzQF && this.zzQG == accountChangeEvent.zzQG && zzw.equal(this.zzQH, accountChangeEvent.zzQH);
        }
        return false;
    }
}

