package com.androidbook.touch.demo1;

// Jest to plik BooleanButton.java
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.Button;

public abstract class BooleanButton extends Button {
    protected boolean myValue() {
    	return false;
    }

	public BooleanButton(Context context, AttributeSet attrs) {
		super(context, attrs);
	}
	
	@Override
	public boolean onTouchEvent(MotionEvent event) {
        String myTag = this.getTag().toString();
        Log.v(myTag, "-----------------------------------");
        Log.v(myTag, MainActivity.describeEvent(this, event));
        Log.v(myTag, "metoda super onTouchEvent() zwraca " + super.onTouchEvent(event));
        Log.v(myTag, "a ja zwracam " + myValue());
        return(myValue());
	}
}
